<?php

namespace Config;
use Config\Services;
/**
 * Database Configuration
 *
 * @package Config
 */

class Database extends \CodeIgniter\Database\Config
{
	/**
	 * The directory that holds the Migrations
	 * and Seeds directories.
	 *
	 * @var string
	 */
	public $filesPath = APPPATH . 'Database/';

	/**
	 * Base database conection params
	 *
	 * @return array
	 */
	public function baseData(array $baseData)
	{
		return [
			'DSN'      => '',
			'hostname' => $baseData['hostname'],
			'username' => $baseData['username'],
			'password' => $baseData['password'],
			'database' => $baseData['database'],
			'DBDriver' => 'MySQLi',
			'DBPrefix' => '',
			'pConnect' => false,
			'DBDebug'  => (ENVIRONMENT !== 'production'),
			'cacheOn'  => false,
			'cacheDir' => '',
			'charset'  => 'utf8',
			'DBCollat' => 'utf8_general_ci',
			'swapPre'  => '',
			'encrypt'  => false,
			'compress' => false,
			'strictOn' => false,
			'failover' => [],
			'port'     => 3306,
		];
	}

	/**
	 * Lets you choose which connection group to
	 * use if no other is specified.
	 *
	 * @var string
	 */
	public $defaultGroup = 'default';

	/**
	 * The default database connection.
	 *
	 * @var array
	 */
	public $default = [
		'DSN'      => '',
		'hostname' => '',
		'username' => '',
		'password' => '',
		'database' => '',
		'DBDriver' => 'MySQLi',
		'DBPrefix' => '',
		'pConnect' => false,
		'DBDebug'  => (ENVIRONMENT !== 'production'),
		'cacheOn'  => false,
		'cacheDir' => '',
		'charset'  => 'utf8',
		'DBCollat' => 'utf8_general_ci',
		'swapPre'  => '',
		'encrypt'  => false,
		'compress' => false,
		'strictOn' => false,
		'failover' => [],
		'port'     => 3306,
	];


	/**
	 * This database connection is used when
	 * running PHPUnit database tests.
	 *
	 * @var array
	 */
	public $tests = [
		'DSN'      => '',
		'hostname' => '127.0.0.1',
		'username' => '',
		'password' => '',
		'database' => ':memory:',
		'DBDriver' => 'SQLite3',
		'DBPrefix' => 'db_',  // Needed to ensure we're working correctly with prefixes live. DO NOT REMOVE FOR CI DEVS
		'pConnect' => false,
		'DBDebug'  => (ENVIRONMENT !== 'production'),
		'cacheOn'  => false,
		'cacheDir' => '',
		'charset'  => 'utf8',
		'DBCollat' => 'utf8_general_ci',
		'swapPre'  => '',
		'encrypt'  => false,
		'compress' => false,
		'strictOn' => false,
		'failover' => [],
		'port'     => 3306,
	];

	/**
	 * This database connection is used for dulcelandia users.
	 *
	 * @var array
	 */

	public $dulcelandia = [];

	/**
	 * This database connection is used for wappsi global db.
	 *
	 * @var array
	 */

	 public $wappsi = [];

	/**
	 * Conexion a multiabastos prueba.
	 *
	 * @var array
	 */

	 public $multiprueba = [];
	 
	 /**
	 * Conexion a Zafra Produccion.
	 *
	 * @var array
	 */

	 public $zafra = [];
	 
	 
	 /**
	 * Conexion a rusbel Produccion.
	 *
	 * @var array
	 */

	 public $rusbel = [];
	 
	 
	 /**
	 * Conexion a envax Produccion.
	 *
	 * @var array
	 */

	 public $envax = [];
	 
	 
	  /**
	 * Conexion a puma Produccion.
	 *
	 * @var array
	 */

	 public $puma = [];
	 
	 
	 	  /**
	 * Conexion a hiper Produccion.
	 *
	 * @var array
	 */

	 public $hiper = [];
	 
	 
	 
	 	  /**
	 * Conexion a cristi Produccion.
	 *
	 * @var array
	 */

	 public $cristi = [];
	 
	 	  /**
	 * Conexion a tumoda Produccion.
	 *
	 * @var array
	 */

	 public $tumoda = [];
	 
	 /**
	 * Conexion a fortunemia Produccion.
	 *
	 * @var array
	 */

	 public $fortunemia = [];
	 
	  /**
	 * Conexion a lacteos_lilianita Produccion.
	 *
	 * @var array
	 */

	 public $lacteos_lilianita = [];
	 
	 

	//--------------------------------------------------------------------

	public function __construct()
	{	
		// /// This is wappsiDB
		
		$this->wappsi =  $this->baseData(
			Services::getCustomDBParams('wappsi')
		);
		
		$this->dulcelandia = $this->baseData(
			Services::getCustomDBParams('dulcelandia')
		);
		
		$this->multiprueba = $this->baseData(
			Services::getCustomDBParams('multiprueba')
		);
		
		$this->zafra = $this->baseData(
			Services::getCustomDBParams('zafra')
		);
		
		$this->envax = $this->baseData(
		    Services::getCustomDBParams('envax')
		);
		
		$this->rusbel = $this->baseData(
			Services::getCustomDBParams('rusbel')
		);
		
		$this->puma = $this->baseData(
			Services::getCustomDBParams('puma')
		);
		
			$this->hiper = $this->baseData(
			Services::getCustomDBParams('hiper')
		);
		
				$this->cristi = $this->baseData(
			Services::getCustomDBParams('cristi')
		);
		
					$this->tumoda = $this->baseData(
			Services::getCustomDBParams('tumoda')
		);
		
					$this->fortunemia = $this->baseData(
			Services::getCustomDBParams('fortunemia')
		);
		
					$this->lacteos_lilianita = $this->baseData(
			Services::getCustomDBParams('lacteos_lilianita')
		);


		
		parent::__construct();

		// Ensure that we always set the database group to 'tests' if
		// we are currently running an automated test suite, so that
		// we don't overwrite live data on accident.
		if (ENVIRONMENT === 'testing') {
			$this->defaultGroup = 'tests';

			// Under Travis-CI, we can set an ENV var named 'DB_GROUP'
			// so that we can test against multiple databases.
			if ($group = getenv('DB')) {
				if (is_file(TESTPATH . 'travis/Database.php')) {
					require TESTPATH . 'travis/Database.php';

					if (!empty($dbconfig) && array_key_exists($group, $dbconfig)) {
						$this->tests = $dbconfig[$group];
					}
				}
			}
		}
	}

	//--------------------------------------------------------------------

}
