<?php
/**
 * payments table's controller.
 *
 * Used to perform operations on payments table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;

use App\Models\SmaPaymentsModel;
use CodeIgniter\RESTful\ResourceController;


class SmaPayments extends ResourceController
{

    /**
     * Given an order sale id, returns it's items
     *
     * @param integer $orderId
     * @return array|null
     */
    static public function getSalePayment($orderId,$dbGroup){
        $orderSaleItemsM = new SmaPaymentsModel($dbGroup);
        $items = $orderSaleItemsM->select('*')->where(['sale_id'=>$orderId])->findAll();
        return $items;
    }
}
