<?php
/**
 * sale_items table's controller.
 *
 * Used to perform operations on sale_items table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;

use App\Models\SmaSaleItemsModel;
use CodeIgniter\RESTful\ResourceController;


class SmaSaleItems extends ResourceController
{

    /**
     * Given an order sale id, returns it's items
     *
     * @param integer $saleId
     * @return array|null
     */
    static public function getSaleItems($saleId,$dbGroup){
        $orderSaleItemsM = new SmaSaleItemsModel($dbGroup);
        // $items = $orderSaleItemsM->select('*')->where(['sale_id'=>$saleId])->findAll();
        $items = $orderSaleItemsM->getSelectedRows(['sale_id'=>$saleId]);

        return $items;
    }
}
