# Wappsi-APIs PHP 7.2

## About CodeIgniter v.

CodeIgniter is a PHP full-stack web framework that is light, fast, flexible, and secure. 
More information can be found at the [official site](http://codeigniter.com).

This version of codeigniter (4.0.4) is a little bit modified to make it work with PHP 7.2. So, you need all code to make it work properly.


## NOTE: For non-terminal users, you can clone repository using cpanel, copy and edit files, and create files and directorys using cpanel file manager.


## 1. Server Requirements

PHP version 7.2 or higher is required, with the following extensions installed: 

- [intl](http://php.net/manual/en/intl.requirements.php)
- [libcurl](http://php.net/manual/en/curl.requirements.php) if you plan to use the HTTP\CURLRequest library

Additionally, make sure that the following extensions are enabled in your PHP:

- json (enabled by default - don't turn it off)
- [mbstring](http://php.net/manual/en/mbstring.installation.php)
- [mysqlnd](http://php.net/manual/en/mysqlnd.install.php)
- xml (enabled by default - don't turn it off)


## 2. Deploy into Server

First, server need to satisfy requirements above.

Connect via SSH to server with a non root user.

    ssh user@serverIP -p22022

### 2.1 Clone reppository into server
Once there, you should be promted to a terminal in user home `/home/user/`. Clone this reppository into it using the following commands

    git clone https://github.com/WappsiMovil/WappsiAPI7.2.git
### 2.2 Copy `WappsiAPI7.2/public/` folder content into `/home/user/public_html/wappsi_apis`

Execute the following commands

    cp -R WappsiAPI7.2/public/* public_html/wappsi_apis

If  `public_html/wappsi_apis` doesnt exist, create it

    mkdir public_html/wappsi_apis/

### 2.3 Edit `public_html/wappsi_apis/index.php`


Using vim, or any text editor on terminal 

    vim public_html/wappsi_apis/index.php

Then modify the following line

<img src="assets/doc/index_to_mod.png" alt="MarineGEO circle logo" style="height: 90px;"/>

To this

<img src="assets/doc/index_mod.png" alt="MarineGEO circle logo" style="height: 90px;"/>

### 2.4 Set .htaccess file into `public_html/wappsi_apis/.htaccess`

To make server redirect all to index.php, to allow http request with http headers and more.., create or modify .htaccess file.

To create or modify, execute the following commands

    vim public_html/wappsi_apis/.htaccess

And copy the following lines into .htaccess

    RewriteEngine On
    RewriteCond %{HTTP:Authorization} ^(.*)
    RewriteRule .* - [e=HTTP_AUTHORIZATION:%1]
    RewriteBase /wappsi_apis/
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^(.*)$ index.php?request=%{REQUEST_URI} [NE,L,QSA]

## 3 Deploy into Server - Configure .env file inside `WappsiAPI7.2`

Create or modify `.env` file inside `WappsiAPI7.2/`

    vim WappsiAPI7.2/.env

Paste the following content inside

   #--------------------------------------------------------------------
    # Example Environment Configuration file
    #
    # This file can be used as a starting point for your own
    # custom .env files, and contains most of the possible settings
    # available in a default install.
    #
    # By default, all of the settings are commented out. If you want
    # to override the setting, you must un-comment it by removing the '#'
    # at the beginning of the line.
    #--------------------------------------------------------------------

    #--------------------------------------------------------------------
    # ENVIRONMENT
    #--------------------------------------------------------------------

    #CI_ENVIRONMENT = production
    CI_ENVIRONMENT = development


    #--------------------------------------------------------------------
    # APP
    #--------------------------------------------------------------------

    app.baseURL = 'http://localhost/wappsi_apis'
    # app.forceGlobalSecureRequests = false

    # app.sessionDriver = 'CodeIgniter\Session\Handlers\FileHandler'
    # app.sessionCookieName = 'ci_session'
    # app.sessionSavePath = NULL
    # app.sessionMatchIP = false
    # app.sessionTimeToUpdate = 300
    # app.sessionRegenerateDestroy = false

    # app.cookiePrefix = ''
    # app.cookieDomain = ''
    # app.cookiePath = '/'
    # app.cookieSecure = false
    # app.cookieHTTPOnly = false

    # app.CSRFProtection  = false
    # app.CSRFTokenName   = 'csrf_test_name'
    # app.CSRFCookieName  = 'csrf_cookie_name'
    # app.CSRFExpire      = 7200
    # app.CSRFRegenerate  = true
    # app.CSRFExcludeURIs = []

    # app.CSPEnabled = false

    #--------------------------------------------------------------------
    # DATABASE
    #--------------------------------------------------------------------

    database.default.hostname = 162.240.44.254
    database.default.username = wwlapa_wp
    database.default.password = WsJh1357#
    database.default.database = wwlapa_lapappaya_pruebas_20

    database.wappsi.hostname = localhost
    database.wappsi.username = root
    database.wappsi.password = root
    database.wappsi.database = wappsi_db
    database.wappsi.DBDriver = MySQLi


    # database.tests.hostname = localhost
    # database.tests.database = ci4
    # database.tests.username = root
    # database.tests.password = root
    # database.tests.DBDriver = MySQLi

    #--------------------------------------------------------------------
    # CONTENT SECURITY POLICY
    #--------------------------------------------------------------------

    # contentsecuritypolicy.reportOnly = false
    # contentsecuritypolicy.defaultSrc = 'none'
    # contentsecuritypolicy.scriptSrc = 'self'
    # contentsecuritypolicy.styleSrc = 'self'
    # contentsecuritypolicy.imageSrc = 'self'
    # contentsecuritypolicy.base_uri = null
    # contentsecuritypolicy.childSrc = null
    # contentsecuritypolicy.connectSrc = 'self'
    # contentsecuritypolicy.fontSrc = null
    # contentsecuritypolicy.formAction = null
    # contentsecuritypolicy.frameAncestors = null
    # contentsecuritypolicy.mediaSrc = null
    # contentsecuritypolicy.objectSrc = null
    # contentsecuritypolicy.pluginTypes = null
    # contentsecuritypolicy.reportURI = null
    # contentsecuritypolicy.sandbox = false
    # contentsecuritypolicy.upgradeInsecureRequests = false

    #--------------------------------------------------------------------
    # ENCRYPTION
    #--------------------------------------------------------------------

    # encryption.key = 
    # encryption.driver = OpenSSL

    #--------------------------------------------------------------------
    # HONEYPOT
    #--------------------------------------------------------------------

    # honeypot.hidden = 'true'
    # honeypot.label = 'Fill This Field'
    # honeypot.name = 'honeypot'
    # honeypot.template = '<label>{label}</label><input type="text" name="{name}" value=""/>'
    # honeypot.container = '<div style="display:none">{template}</div>'

    #----------------------------------------------------------------------
    #JWT_KEY
    #----------------------------------------------------------------------
    API_KEY = xvDG6LZc7YsoI4yrXuxK

    #----------------------------------------------------------------------
    #PASSWORD DECODE PARAMS
    #----------------------------------------------------------------------

    PASSWORD_KEY = TndnTUxZSkg3clJ2RTR0VkdnTEo4a3R0dkpUWXhLR1M=
    PASSWORD_IV = gFDfQctFtNPSpiDD

    #----------------------------------------------------------------------
    #WAPPSI_WEB_ENDPOINTS
    #----------------------------------------------------------------------
    WAPPSI_WEB_SALES_ENDPOINT = /admin/mobile/app_add_sale
    WAPPSI_WEB_REGISTER_ENDPOINT = /admin/mobile/app_pos_register_add_movement


### 3.1 Set base URL 

Modify `app.baseURL` in .env file with the url of server with `/wappsi_apis/` at the end of it

    #--------------------------------------------------------------------
    # APP
    #--------------------------------------------------------------------

    app.baseURL = 'http://url_of_server.com/wappsi_apis'

### 3.2 Set JWT generation key

Modify `API_KEY` in .env file with a random string of len 20, this param is used to gen JWT to manage user sessions

    #----------------------------------------------------------------------
    #JWT_KEY
    #----------------------------------------------------------------------
    API_KEY = xvDG6LZc7YsoI4yrXuxK

    

### 3.3 Set the decrypt password params

Modify the following lines to add the decrypt password params, they should be equal to the used to encrypt password

    #----------------------------------------------------------------------
    #PASSWORD DECODE PARAMS
    #----------------------------------------------------------------------

    PASSWORD_KEY = TndnTUxZSkg3clJ2RTR0VkdnTEo4a3R0dkpUWXhLR1M=
    PASSWORD_IV = gFDfQctFtNPSpiDD

PASSWORD_KEY should be a random string with lenght 32, encoded in Base64.

PASSWORD_IV should be a random string with lenght 16

### 3.4 Set sales and register movements endpoints

    #----------------------------------------------------------------------
    #WAPPSI_WEB_ENDPOINTS
    #----------------------------------------------------------------------
    WAPPSI_WEB_SALES_ENDPOINT = end_point_to_sales_on_wappsi
    WAPPSI_WEB_REGISTER_ENDPOINT = end_point_to_register_movements_on_wappsi

Default values of this two params are:

    WAPPSI_WEB_SALES_ENDPOINT = admin/mobile/app_add_sale
    WAPPSI_WEB_REGISTER_ENDPOINT = /admin/mobile/app_pos_register_add_movement

## 4. Set databases connection params.

### 4.1 Set Wappsi database params to connect


Modify the following lines inside .env file on `WappsiAPI7.2/.env`, set the DB params to connect

    #--------------------------------------------------------------------
    # DATABASE
    #--------------------------------------------------------------------

    database.wappsi.hostname = localhost
    database.wappsi.username = root
    database.wappsi.password = root
    database.wappsi.database = wappsi_db
    database.wappsi.DBDriver = MySQLi

### 4.2 Set other host databases params to connect


Add the following lines inside .env file on `WappsiAPI7.2/.env`, set the DB params to connect
    

    database.database_group.hostname = localhost
    database.database_group.username = root
    database.database_group.password = root
    database.database_group.database = wappsi_db
    database.database_group.DBDriver = MySQLi

Replace `database_group` with a custom name for the new database connection.

Find and open `Database.php` on `path_to_project/app/Config/`. And add find the following lines:

    /**
	 * This database connection is used for wappsi global db.
	 *
	 * @var array
	 */

	 public $wappsi = [];

	//--------------------------------------------------------------------

	public function __construct()
	{	
		// /// This is wappsiDB
		$this->wappsi =  $this->baseData(
			Services::getCustomDBParams('wappsi'),
		);
		parent::__construct();

Then, to add new database group `database_group`, modify it to be like:

    /**
	 * This database connection is used for wappsi global db.
	 *
	 * @var array
	 */

	 public $wappsi = [];

     /**
	 * This database connection is used to connect to another db.
	 *
	 * @var array
	 */

	 public $database_group = [];

	//--------------------------------------------------------------------

	public function __construct()
	{	
		// /// This is wappsiDB
		$this->wappsi =  $this->baseData(
			Services::getCustomDBParams('wappsi'),
		);
		// /// This is to connect to another db
		$this->database_group =  $this->baseData(
			Services::getCustomDBParams('database_group'),
		);
		parent::__construct();

Replace `database_group` with a custom name for the new database connection.