<?php

namespace Config;

use CodeIgniter\Config\BaseService;

/**
 * Services Configuration file.
 *
 * Services are simply other classes/libraries that the system uses
 * to do its job. This is used by CodeIgniter to allow the core of the
 * framework to be swapped out easily without affecting the usage within
 * the rest of your application.
 *
 * This file holds any application-specific services, or service overrides
 * that you might need. An example has been included with the general
 * method format you should use for your service methods. For more examples,
 * see the core Services file at system/Config/Services.php.
 */
class Services extends BaseService
{

    //    public static function example($getShared = true)
    //    {
    //        if ($getShared)
    //        {
    //            return static::getSharedInstance('example');
    //        }
    //
    //        return new \CodeIgniter\Example();
    //    }
    public static function getJWTKey()
    {
        return getenv('API_KEY');
    }

    /**
     * Returns WAPPSI_WEB_ENDPOINT value saved in .env file
     *
     * @return void
     */
    public static function getWappsiWebSalesEndpoint()
    {
        return getenv('WAPPSI_WEB_SALES_ENDPOINT');
    }

    public static function getWappsiWebRegisterEndpoint()
    {
        return getenv('WAPPSI_WEB_REGISTER_ENDPOINT');
    }

    // Key to decript password comming from user login
    public static function getEncodedPasswordKey()
    {
        return getenv('PASSWORD_KEY');
    }

    /**
     * Get a custon var from ENVIRONMENT
     * 
     */
    public static function getCustomDBParams(String $name)
    {
        return [
            'hostname' => getenv('database.' . $name . '.hostname'),
            'username' => getenv('database.' . $name . '.username'),
            'password' => getenv('database.' . $name . '.password'),
            'database' => getenv('database.' . $name . '.database')
        ];
    }

    /**
     * Function to check the string is ends with given substring or not
     *
     * @param String $string
     * @param String $endString
     * @return bool
     */
    public static function endsWith($string, $endString)
    {
        $len = strlen($endString);
        if ($len == 0) {
            return true;
        }
        return (substr($string, -$len) === $endString);
    }

    /**
     * Function to check the string is starts with given substring or not
     *
     * @param String $string
     * @param String $endString
     * @return bool
     */
    public static function startsWith($string, $startString)
    {
        $len = strlen($startString);
        return (substr($string, 0, $len) === $startString);
    }

    /**
     * Function to build an URL "safely"
     *
     * @param String $string1
     * @param String $sting2
     * @return String
     */
    public static function buildURL($string1, $string2)
    {
        // $len1 = strlen($string1);

        $len2 = strlen($string2);
        if (Services::endsWith($string1, '/')) {
            if (Services::startsWith($string2, '/')) {
                $t = substr($string2, 1, $len2);
                $url = $string1 . $t;
            } else {

                $url = $string1 . $string2;
            }
        } else {
            if (Services::startsWith($string2, '/')) {
                $url = $string1 . $string2;
            } else {
                // echo 'here';
                $url = $string1 . "/" . $string2;
            }
        }
        return $url;
    }

    // Iv to decript password comming from user login
    public static function getEncodedPasswordIv()
    {
        return getenv('PASSWORD_IV');
    }
}
