<?php

/**
 * Controller used to perfom actions on Sales and related tables
 *
 * 
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
 */

namespace App\Controllers;

//
//

use App\Models\SmaCompaniesModel;
use App\Validation\SalesValidation;
use Config\Services;
use CodeIgniter\RESTful\ResourceController;

class Sales extends ResourceController
{
    public function index()
    {
        //
    }


    /**
     * Creates a sale for a given data on post request
     * 
     * Request type: POST
     * Request validation rules can be viewed on
     * 
     * @filesource App\Validation\SalesValidation::newSaleRules()
     * @filesource App\Validation\SalesValidation::newSaleMessages()
     *
     * @return httpResponse
     */
    function new()
    {
        // $this->setModel(new SmaCompaniesModel($this->dbGroupFromRequest()));

        // print_r($this->request->getJSON());

        $rules = SalesValidation::newSaleRules();

        $message = SalesValidation::newSaleMessages();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
            ];

            return $this->respondCreated($response);
        } else {
            $sale = $this->request->getJSON(true);
            // print_r($this->checkSale($sale));
            $syncValidation = $this->checkSale($sale);

            // print_r($syncValidation);
            if (
                $sale != null
            ) {
                // if (
                //     $syncValidation['sma_warehouses_products'] == false && ($syncValidation['sma_products']) == false
                //     && ($syncValidation['sma_product_prices']) == false && ($syncValidation['sma_companies']) == false
                //     && ($syncValidation['sma_units']) == false && ($syncValidation['sma_unit_prices']) == false
                // ) {
                $sale['from_app'] = true;

                $sale[csrf_token()] = csrf_hash();

                // print_r($sale);

                // to get wappsi endPoint to sales
                // helper('jwt');
                // $authHeader = $this->request->getServer('HTTP_AUTHORIZATION');
                // $token = getJWTFromRequest($authHeader);
                // $company_url = companyURLFromJWT($token);
                // // $company_url = "https://wappsi281.com/dulcelandia_2/";
                // $wappsi_web_endp = Services::getWappsiWebSalesEndpoint();

                ///TODO: Remove this step
                // $defaultSaleCurrency = SmaCurrencies::getDefaultCurrency($this->dbGroupFromRequest());

                $sale['sale_currency'] = 'COP';

                //build url
                // $url = Services::buildURL($company_url, $wappsi_web_endp);
                $url = 'https://wappsi281.com/zafra/admin/mobile/app_add_sale';
                // return $this->respondCreated([
                //     'url'=>$url,
                //     'data'=>http_build_query($sale),
                //     'data_json'=>$sale,
                // ]);
                $regSale = $this->httpPostXform($url, $sale);

                $regSale = $this->renameKey(json_decode($regSale), "\"", '');


                if (isset($regSale['error'])) {
                    $regSale['error'] == 1 ? $regSale['error'] = true : $regSale['error'] = false;
                } else {
                    $regSale['error'] = true;
                }
                if ($regSale['error'] == true) {
                    // log error 
                    log_message('critical', json_encode($regSale));
                }

                $regSale['fe_print_footer'] = AppSettings::getStaticFooterPrint($this->dbGroupFromRequest());

                $feXml = '<?xml version="1.0" encoding="UTF-8" standalone="no"?>
                <AttachedDocument xmlns="urn:oasis:names:specification:ubl:schema:xsd:AttachedDocument-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:xades="http://uri.etsi.org/01903/v1.3.2#" xmlns:xades141="http://uri.etsi.org/01903/v1.4.1#">
                <cac:ParentDocumentLineReference><cbc:LineID>1</cbc:LineID><cac:DocumentReference><cbc:ID>FA25</cbc:ID><cbc:UUID schemeID="1" schemeName="CUFE-SHA384">0185dec1622e4a219629ebbb4b428edb3a37537a1f9710a4255e8bb4083d4c1a887a8f1e42d57a2756998f8659941ecb</cbc:UUID><cbc:IssueDate>2023-04-20</cbc:IssueDate><cbc:DocumentType>ApplicationResponse</cbc:DocumentType><cac:Attachment><cac:ExternalReference><cbc:MimeCode>text/xml</cbc:MimeCode><cbc:EncodingCode>UTF-8</cbc:EncodingCode><cbc:Description><![CDATA[<?xml version="1.0" encoding="utf-8" standalone="no"?><ApplicationResponse xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:sts="dian:gov:co:facturaelectronica:Structures-2-1" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns="urn:oasis:names:specification:ubl:schema:xsd:ApplicationResponse-2">
                  <ext:UBLExtensions>
                    <ext:UBLExtension>
                      <ext:ExtensionContent>
                        <sts:DianExtensions>
                          <sts:InvoiceSource>
                            <cbc:IdentificationCode listAgencyID="6" listAgencyName="United Nations Economic Commission for Europe" listSchemeURI="urn:oasis:names:specification:ubl:codelist:gc:CountryIdentificationCode-2.1">CO</cbc:IdentificationCode>
                          </sts:InvoiceSource>
                          <sts:SoftwareProvider>
                            <sts:ProviderID schemeID="4" schemeName="31" schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)">800197268</sts:ProviderID>
                            <sts:SoftwareID schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)">...</sts:SoftwareID>
                          </sts:SoftwareProvider>
                          <sts:SoftwareSecurityCode schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)">...</sts:SoftwareSecurityCode>
                          <sts:AuthorizationProvider>
                            <sts:AuthorizationProviderID schemeID="4" schemeName="31" schemeAgencyID="195" schemeAgencyName="CO, DIAN (Dirección de Impuestos y Aduanas Nacionales)">800197268</sts:AuthorizationProviderID>
                          </sts:AuthorizationProvider>
                        </sts:DianExtensions>
                      </ext:ExtensionContent>
                    </ext:UBLExtension>
                    <ext:UBLExtension>
                      <ext:ExtensionContent><ds:Signature xmlns:ds="http://www.w3.org/2000/09/xmldsig#" Id="Signature-0dd66e59-b3a3-4c63-8a14-858b2f57b6e8"><ds:SignedInfo><ds:CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315" /><ds:SignatureMethod Algorithm="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256" /><ds:Reference Id="Reference-b481af8c-8a1f-4251-a0db-16f4c279e538" URI=""><ds:Transforms><ds:Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature" /></ds:Transforms><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256" /><ds:DigestValue>GfGS7s7ucmTf1/o8T/x38TLtK/LFonLnJQ+34DBhx04=</ds:DigestValue></ds:Reference><ds:Reference Id="ReferenceKeyInfo" URI="#Signature-0dd66e59-b3a3-4c63-8a14-858b2f57b6e8-KeyInfo"><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256" /><ds:DigestValue>LVt7BkWIGSIHlwOrB3pBHHOjFdJG2jyW69iASfrIHBc=</ds:DigestValue></ds:Reference><ds:Reference Type="http://uri.etsi.org/01903#SignedProperties" URI="#xmldsig-Signature-0dd66e59-b3a3-4c63-8a14-858b2f57b6e8-signedprops"><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256" /><ds:DigestValue>3vNjuOYyScRkZOsXLtwzkePPaU5LxEOovpJNc8dzxng=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue Id="SignatureValue-0dd66e59-b3a3-4c63-8a14-858b2f57b6e8">JWDZhBaeORHhocvNON/aynAPEK9jgk4eQ5sXnVVrHHOvsmnvXgJE7uSQ2C/8F8h4WDaGRodfodMToHdd3kdCLrMZPbIb5dXhlfW5YYmaFuozEsJZvdKhH+GnxC2ZE1INdu3vQ9kPswEKVyLvrB6Lbxm/Zsyg9bOkHF7MSj78pG86cuMVJXvQDhULWTxh/eY/5ALqb1loHq3oamPmavAT06faW8gJs5JXLDjgmMDIo1ycLs6ihhXnvvN8MH0YBqxOoxBTR4JwoS735Uir9N6Hf8LkAZeDy2RQlBRgyX7eK1z/ZxKgeBhyrJYZrvxfJ1/zQv6OWv8S7q9UlPnz5jdCRg==</ds:SignatureValue><ds:KeyInfo Id="Signature-0dd66e59-b3a3-4c63-8a14-858b2f57b6e8-KeyInfo"><ds:X509Data><ds:X509Certificate>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</ds:X509Certificate></ds:X509Data><ds:KeyValue><ds:RSAKeyValue><ds:Modulus>kglVWvln+B6oWeplU68AIkM2MvVkAE5XFv73WH+GT9vGzVbkaBD9rYnWNOlazJy1bNUg3UDursa9m3SOiLdW7biUj1jXttw/S/gekaywjaK/myys/uN9PmZcB1pVgdE5oY95ggtfLbuw90vrp8UMEX02BbMDzRnDXgQI6dvFnZxd4wAEWsvSo5z2/VpYkmumypE1rMLzHu4GKD6quGmrA8X7W9BBKHao/GlSqZpGIRQOaAxsebNhflUEsfWZk+Qj05MryBKcUyEgZD1VIbdfSKrQOs2w3fitJ9A0OPAEyOzcWXyWIejJItL5Pk0knaLJZi2Dbd/ZksVaU2m3HKVa6w==</ds:Modulus><ds:Exponent>AQAB</ds:Exponent></ds:RSAKeyValue></ds:KeyValue></ds:KeyInfo><ds:Object Id="XadesObjectId-dd02f8d1-7e63-4cbc-b112-365526f584e6"><xades:QualifyingProperties xmlns:xades="http://uri.etsi.org/01903/v1.3.2#" Id="QualifyingProperties-30add9dc-bf21-451b-9ba0-b32ef0d278dc" Target="#Signature-0dd66e59-b3a3-4c63-8a14-858b2f57b6e8"><xades:SignedProperties Id="xmldsig-Signature-0dd66e59-b3a3-4c63-8a14-858b2f57b6e8-signedprops"><xades:SignedSignatureProperties><xades:SigningTime>2023-04-20T16:54:13+00:00</xades:SigningTime><xades:SigningCertificate><xades:Cert><xades:CertDigest><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256" /><ds:DigestValue>y3nFbBGB1gFi98Lqjh5h3ItZ60ysAEH+o6ZPIxn4egQ=</ds:DigestValue></xades:CertDigest><xades:IssuerSerial><ds:X509IssuerName>C=CO, L=Bogota D.C., O=GSE, OU=PKI, CN=Autoridad Subordinada 01 GSE, E=info@gse.com.co</ds:X509IssuerName><ds:X509SerialNumber>68093060544308893515499</ds:X509SerialNumber></xades:IssuerSerial></xades:Cert></xades:SigningCertificate><xades:SignaturePolicyIdentifier><xades:SignaturePolicyId><xades:SigPolicyId><xades:Identifier>https://facturaelectronica.dian.gov.co/politicadefirma/v2/politicadefirmav2.pdf</xades:Identifier><xades:Description /></xades:SigPolicyId><xades:SigPolicyHash><ds:DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256" /><ds:DigestValue>dMoMvtcG5aIzgYo0tIsSQeVJBDnUnfSOfBpxXrmor0Y=</ds:DigestValue></xades:SigPolicyHash></xades:SignaturePolicyId></xades:SignaturePolicyIdentifier><xades:SignerRole><xades:ClaimedRoles><xades:ClaimedRole>supplier</xades:ClaimedRole></xades:ClaimedRoles></xades:SignerRole></xades:SignedSignatureProperties><xades:SignedDataObjectProperties><xades:DataObjectFormat ObjectReference="#Reference-b481af8c-8a1f-4251-a0db-16f4c279e538"><xades:MimeType>text/xml</xades:MimeType><xades:Encoding>UTF-8</xades:Encoding></xades:DataObjectFormat></xades:SignedDataObjectProperties></xades:SignedProperties></xades:QualifyingProperties></ds:Object></ds:Signature></ext:ExtensionContent>
                    </ext:UBLExtension>
                  </ext:UBLExtensions>
                  <cbc:UBLVersionID>UBL 2.1</cbc:UBLVersionID>
                  <cbc:CustomizationID>1</cbc:CustomizationID>
                  <cbc:ProfileID>DIAN 2.1</cbc:ProfileID>
                  <cbc:ProfileExecutionID>1</cbc:ProfileExecutionID>
                  <cbc:ID>16473275</cbc:ID>
                  <cbc:UUID schemeName="CUDE-SHA384">e70c7436e0ed0670fef6bde82deae99d4b1e84938bd9b383075d4898a6c93701ec0a077f2f141560b7856bb19c0a07ca</cbc:UUID>
                  <cbc:IssueDate>2023-04-20</cbc:IssueDate>
                  <cbc:IssueTime>16:54:13-05:00</cbc:IssueTime>
                  <cac:SenderParty>
                    <cac:PartyTaxScheme>
                      <cbc:RegistrationName>Unidad Especial Dirección de Impuestos y Aduanas Nacionales</cbc:RegistrationName>
                      <cbc:CompanyID schemeID="4" schemeName="31">800197268</cbc:CompanyID>
                      <cac:TaxScheme>
                        <cbc:ID>01</cbc:ID>
                        <cbc:Name>IVA</cbc:Name>
                      </cac:TaxScheme>
                    </cac:PartyTaxScheme>
                  </cac:SenderParty>
                  <cac:ReceiverParty>
                    <cac:PartyTaxScheme>
                      <cbc:RegistrationName>Jose Edgar Neuta Maldonado</cbc:RegistrationName>
                      <cbc:CompanyID schemeID="4" schemeName="31">80266549</cbc:CompanyID>
                      <cac:TaxScheme>
                        <cbc:ID>01</cbc:ID>
                        <cbc:Name>IVA</cbc:Name>
                      </cac:TaxScheme>
                    </cac:PartyTaxScheme>
                  </cac:ReceiverParty>
                  <cac:DocumentResponse>
                    <cac:Response>
                      <cbc:ResponseCode>02</cbc:ResponseCode>
                      <cbc:Description>Documento validado por la DIAN</cbc:Description>
                    </cac:Response>
                    <cac:DocumentReference>
                      <cbc:ID>FA25</cbc:ID>
                      <cbc:UUID schemeName="CUFE-SHA384">0185dec1622e4a219629ebbb4b428edb3a37537a1f9710a4255e8bb4083d4c1a887a8f1e42d57a2756998f8659941ecb</cbc:UUID>
                    </cac:DocumentReference>
                    <cac:LineResponse>
                      <cac:LineReference>
                        <cbc:LineID>1</cbc:LineID>
                      </cac:LineReference>
                      <cac:Response>
                        <cbc:ResponseCode>0000</cbc:ResponseCode>
                        <cbc:Description>0</cbc:Description>
                      </cac:Response>
                    </cac:LineResponse>
                    <cac:LineResponse>
                      <cac:LineReference>
                        <cbc:LineID>2</cbc:LineID>
                      </cac:LineReference>
                      <cac:Response>
                        <cbc:ResponseCode>RUT01</cbc:ResponseCode>
                        <cbc:Description>La validación del estado del RUT próximamente estará disponible.</cbc:Description>
                      </cac:Response>
                    </cac:LineResponse>
                    <cac:LineResponse>
                      <cac:LineReference>
                        <cbc:LineID>3</cbc:LineID>
                      </cac:LineReference>
                      <cac:Response>
                        <cbc:ResponseCode>RUT01</cbc:ResponseCode>
                        <cbc:Description>La validación del estado del RUT próximamente estará disponible.</cbc:Description>
                      </cac:Response>
                    </cac:LineResponse>
                  </cac:DocumentResponse>
                </ApplicationResponse>]]>
                </cbc:Description>
                </cac:ExternalReference>
                </cac:Attachment>
                  <cac:ResultOfVerification>
                    <cbc:ValidatorID>Unidad Especial Dirección de Impuestos y Aduanas Nacionales</cbc:ValidatorID>
                    <cbc:ValidationResultCode>02</cbc:ValidationResultCode>
                    <cbc:ValidationDate>2023-04-20</cbc:ValidationDate>
                    <cbc:ValidationTime>16:54:13-05:00</cbc:ValidationTime>
                  </cac:ResultOfVerification>
                  </cac:DocumentReference>
                  </cac:ParentDocumentLineReference></AttachedDocument>
                ';
                $regSale['data']['fe_xml'] = $feXml;
                $regSale['fe_xml'] = $feXml;
                $regSale['data']['cufe'] = '0185dec1622e4a219629ebbb4b428edb3a37537a1f9710a4255e8bb4083d4c1a887a8f1e42d57a2756998f8659941ecb';
                $regSale['cufe'] = '0185dec1622e4a219629ebbb4b428edb3a37537a1f9710a4255e8bb4083d4c1a887a8f1e42d57a2756998f8659941ecb';

                try {
                    if ($regSale['error'] ?? true) {
                        $response = [
                            'status' => 401,
                            'error' => true,
                            'sync' => false,
                            'message' => $regSale['message'] ?? "Ha ocurrido un error al registrar la venta en erp.",
                            'data' => $regSale,
                            'endpoint_erp' => $url,
                            'data_sent' => ($sale),
                        ];
                    } else {
                        $response = [
                            'status' => 201,
                            'error' => false,
                            'current_server_date' => $this->getServerDateTime(),
                            'sync' => false,
                            'message' => $regSale['message'],
                            'data' => $regSale,
                        ];
                    }
                } catch (\Throwable $th) {
                    $response = [
                        'status' => 401,
                        'error' => true,
                        'sync' => false,
                        'message' => 'Error en el registro de la venta',
                        'error_message' => "$th",
                        'data' => $regSale,
                    ];
                }

                // $response = $regSale;

                return $this->respondCreated($response);
            } else {
                $response = [
                    'status' => 401,
                    'error' => true,
                    'sync' => true,
                    'message' => 'Detalles de productos no sincronizados con el servidor, sincronizando',
                    'data' => $syncValidation,
                ];

                return $this->respondCreated($response);
            }
        }
    }

    /**
     * Checks sale data
     * 
     * Verify if overselling is allowed in settings (sma_settings), if it's allowed return [],
     * if not return array of changes that could be empty.
     *
     *
     * @param array  $sale  Sale data to verify
     *
     * @return array|[]
     */
    public function checkSale($sale)
    {
        // return [
        //     'sma_warehouses_products' => false, 'sma_product_prices' => false,
        //     "sma_products" => false, "sma_companies" => false, 'sma_units' => false, 'sma_unit_prices' => false,
        // ];
        // print_r('here');

        $result = SmaSettings::getSettingsColumnData('overselling', $this->dbGroupFromRequest());
        if ($result == 0) {
            return $this->verifyProductsDetails($sale, true, $this->dbGroupFromRequest());
        } else {
            return $this->verifyProductsDetails($sale, false, $this->dbGroupFromRequest());
        }
    }

    /**
     * Verify product data from sale
     * 
     * Returns list of arrays, ['sma_warehouses_products'] is sma_warehouses_products,
     * ['sma_product_prices'] are sma_product_prices and ['sma_products']
     * is sma_products, only return values if there is some irregularity
     *
     * @param array  $sale  Sale data to verify
     *
     * @param boolean  $verifyQuantities  To specify if quantity verification (inventory) is required
     *
     * @return array|[] Array containing table names were changes where found
     */
    public function verifyProductsDetails($sale, $verifyQuantities = true, String $dbGroup)
    {
        $pricePolicy = SmaSettings::getSettingsColumnData('prioridad_precios_producto', $dbGroup);
        $customer = SmaCompanies::getCompaniesData($sale['customer'], $dbGroup);

        // $billerPId   = $this->
        $sync = [
            'sma_warehouses_products' => false, 'sma_product_prices' => false,
            "sma_products" => false, "sma_companies" => false, 'sma_units' => false, 'sma_unit_prices' => false
        ];
        // print_r(($sync['sma_warehouses_products']==false)?1:0);
        foreach ($sale['product_id'] as $key => $value) {
            if ($verifyQuantities) {
                $sync['sma_warehouses_products'] = SmaWarehousesProducts::verifyProductsQuantities(
                    $value,
                    $sale['quantity'][$key],
                    $sale['warehouse'],
                    $dbGroup,
                );
            }

            // If sale requires to verify prices
            if ($sale["verify_prices"] == 1) {
                if ($pricePolicy == 6) {
                    $billerPId = SmaBillerData::getBillerData($sale['biller'], 'default_price_group', $dbGroup);
                    $cAddressPId = SmaAddresses::getAddressesData($sale['address_id'], 'price_group_id', $dbGroup);
                    if (($customer['price_group_id'] == $sale['customer_price_group_id']) &&
                        $customer['customer_group_id'] == $sale['customer_group_id']
                    ) {
                        $temp = $this->verifyProductsPrices(
                            $value,
                            $sale['real_unit_price'][$key],
                            $sale['unit_price'][$key],
                            $customer['price_group_id'],
                            $billerPId,
                            $cAddressPId,
                            null,
                            $pricePolicy,
                            $dbGroup,
                        );
                        if ($temp['sma_product_prices']) {

                            $sync['sma_product_prices'] = $temp['sma_product_prices'];
                        }
                        if ($temp['sma_products']) {

                            $sync['sma_products'] = $temp['sma_products'];
                        }
                    } else {
                        $sync['sma_companies'] = true;
                    }
                } else if ($pricePolicy == 10) {
                    // print_r($value);
                    $temp = $this->verifyProductsPrices(
                        $value,
                        $sale['real_unit_price'][$key],
                        $sale['unit_price'][$key],
                        null,
                        null,
                        null,
                        $sale['product_unit_id_selected'][$key] ?? null,
                        $pricePolicy,
                        $dbGroup,
                    );
                    // $sync['sma_product_prices'] = $temp['sma_product_prices'];
                    // print_r($temp['sma_products']==true?1:0);
                    if ($temp['sma_products']) {

                        $sync['sma_products'] = $temp['sma_products'];
                    }
                    if ($temp['sma_units']) {

                        $sync['sma_units'] = $temp['sma_units'];
                    }
                    if ($temp['sma_unit_prices']) {

                        $sync['sma_unit_prices'] = $temp['sma_unit_prices'];
                    }
                }
            }
        }

        return $sync;
    }


    /**
     * Verify product prices 
     * 
     * Returns array from sma_price_products where base price of given product
     * in sale is difererent based on sma_prioridad_precios_producto.
     *
     * @param int $product  product_id
     * @param double $productPrice  
     * @param double $realProductPrice
     * @param int $customerPGId Customer price group id
     * @param int $billerPId    Biller Id
     * @param int $cAddressPId  Customer address price_group_id
     * @param int $pricePolicy  Price policy param from settings
     *
     * @return array
     */
    public function verifyProductsPrices($product, $realProductPrice, $productPrice = 0, $customerPGId, $billerPId, $cAddressPId, $unit_id, $pricePolicy, String $dbGroup)
    {
        $resp = ['sma_products' => false, "sma_product_prices" => false, 'sma_units' => false, 'sma_unit_prices' => false];

        if ($pricePolicy == 6) {
            $productPromo = SmaProducts::getProductPromo($product, $dbGroup);
            if ($productPromo == null) {
                $pResp = SmaProductPrices::getProductPrices($product, $customerPGId, $dbGroup);
                if ($pResp == null) {
                    $pResp = SmaProductPrices::getProductPrices($product, $billerPId, $dbGroup);
                    if ($pResp != null) {

                        if ($pResp['price'] != $realProductPrice) {
                            $resp['sma_product_prices'] = true;
                            /// force sma_products to be sync
                            $resp['sma_products'] = true;
                        }
                    } else {
                        $pResp = SmaProductPrices::getProductPrices($product, $cAddressPId, $dbGroup);
                        if (!empty($pResp)) {
                            if ($pResp['price'] != $realProductPrice) {
                                $resp['sma_product_prices'] = true;
                                /// force sma_products to be sync
                                $resp['sma_products'] = true;
                            }
                        }
                    }
                } else {

                    if ($pResp['price'] != $realProductPrice) {
                        $resp['sma_product_prices'] = true;
                        /// force sma_products to be sync
                        $resp['sma_products'] = true;
                    }
                }
            } else {

                if ($productPromo['tax_method'] == 0) {
                    if ($productPrice != $productPromo['promo_price']) {
                        $resp['sma_products'] = true;
                    }
                } else {

                    if ($productPrice != $productPromo['promo_price']) {
                        $resp['sma_products'] = true;
                    }
                }
                // if($sale[})
            }
        } else if ($pricePolicy == 10) {
            $pResp = SmaUnitPrices::getUnitPrices($product, $customerPGId, $unit_id, $dbGroup);
            if (!empty($pResp)) {
                $pPrice = $pResp['valor_unitario'] / ($pResp['operation_value'] ?? 1);
                if ($realProductPrice != $pPrice) {

                    $resp['sma_unit_prices'] = true;
                    // $resp['sma_products']=true;
                }
            } else {
                $pResp = SmaUnitPrices::getDefaultUnitPrices($product, $unit_id, $dbGroup);
                if (!empty($pResp)) {
                    $pPrice = $pResp['valor_unitario'] / ($pResp['operation_value'] ?? 1);
                    // print_r($pResp['valor_unitario']/($pResp['operation_value']??1));
                    if ($realProductPrice != $pPrice) {

                        // $resp['sma_unit_prices']=true;
                        $resp['sma_products'] = true;
                    }
                } else {
                    // $pResp = SmaUnitPrices::getDefaultUnitPrices($product, $unit_id);
                    $resp['sma_units'] = true;
                }
            }
        }

        return $resp;
    }
}
