<?php

/**
 * order_sale_items table's controller.
 *
 * Used to perform operations on order_sale_items table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
 */

namespace App\Controllers;

use App\Models\SmaOrderSaleItemsModel;
use CodeIgniter\RESTful\ResourceController;


class SmaOrderSaleItems extends ResourceController
{

    /**
     * Insert order sale items.
     * 
     * Insert order items inside order_sale_items, $items param shoul be an array of arrays, where keys are
     * table names for each value
     *
     * @param array $items order_sale_items data.
     * @param integer $orderSaleId  order sale id to asing to order_sale_items.
     * 
     * @return int|boolean
     */
    static public function insertOrderItems($items, $orderSaleId,String $dbGroup)
    {
        $orderSaleItemsM = new SmaOrderSaleItemsModel($dbGroup);

        // save order id inside all order items
        for ($i = 0; $i < count($items); $i++) {
            $items[$i]['sale_id'] = $orderSaleId;
        }
        $result = $orderSaleItemsM->insertBatch($items);

        return $result;
    }

    /**
     * Given an order sale id, returns it's items
     *
     * @param integer $orderId
     * @return array if empty array, no data found.
     */
    static public function getOrderItems($orderId, String $dbGroup)
    {
        $orderSaleItemsM = new SmaOrderSaleItemsModel($dbGroup);
        $items = $orderSaleItemsM->getSelectedRows(['sale_id' => $orderId]);
        return $items;
    }
}
