<?php
/**
 * purchase_items table's controller.
 *
 * Used to perform operations on purchase_items table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/          
namespace App\Controllers;

use App\Models\SmaPurchaseItemsModel;
use CodeIgniter\RESTful\ResourceController;


class SmaPurchaseItems extends ResourceController
{
    
    /**
     * Insert quote items inside quote_items, $items param shoul be an array of arrays, where keys are
     * table names for each value
     *
     * @param array $items
     * @param integer $purchase_id
     * 
     * @return int|null
     */
    static public function insertPurchaseItems($items,$purchase_id,$dbGroup){
        $purchaseItemsModel = new SmaPurchaseItemsModel($dbGroup);

        // save quote id inside all quote items
        for ($i=0; $i < count($items); $i++) { 
            $items[$i]['purchase_id'] = $purchase_id;
        }
        $result = $purchaseItemsModel->insertBatch($items);

        return $result;
    } 
    /**
     * Given an quote id, returns it's items
     *
     * @param integer $purchase_id
     * @return array|null
     */
    static public function getPurchaseItems($purchase_id,$dbGroup){
        $purchaseItemsModel = new SmaPurchaseItemsModel($dbGroup);
        $items = $purchaseItemsModel->getSelectedRows(['purchase_id'=>$purchase_id]);

        return $items;
    }
}
