<?php

use App\Controllers\SmaSettings;
use App\Controllers\AppBackendSettings;

function sendOrderEmail($orderData, $orderItemsData, $dbGroup)
{

    try {
        $host_url = 'https://lapappaya.com/erp/';
        $settingsData = SmaSettings::getSettingsColumnsData(
            [
                'email_new_order_sale_notification',
                'mailpath', 'protocol', 'smtp_host',
                'smtp_user', 'smtp_pass',
                'smtp_port',
                'smtp_crypto',
                'razon_social',
                'nombre_comercial',
                'logo',
            ],
            $dbGroup,
        );

        $config = [
            'protocol' => $settingsData['protocol'],
            'mailPath' => $settingsData['mailpath'],
            'SMTPHost' => $settingsData['smtp_host'],
            'SMTPUser' => $settingsData['smtp_user'],
            'SMTPPass' => $settingsData['smtp_pass'],
            'SMTPPort' => $settingsData['smtp_port'],
            'SMTPCrypto' => $settingsData['smtp_crypto'],
        ];
        helper('order_email');
        //build email html
        $header = emailHeader($settingsData['nombre_comercial'], $host_url . 'assets/uploads/logos/logo_wappsi.png', $host_url);
        $head = emailHead('Saludos', 'Se ha generado la siguiente orden de pedido desde WappsiPOSApp ');
        $orderHead = orderHeader($orderData);
        $body = emailOrderBodyWUnits($orderData, $orderItemsData);
        $footer = emailFooter($host_url . '/themes/default/admin/assets/images/logo_login.png', $settingsData['nombre_comercial'], 'Has recibido este correo con el fin de informarte acerca de una nueva orden de pedido');

        $message = $header . $head . $orderHead . $body . $footer;
        $email = \Config\Services::email();
        $email->initialize($config);
        $email->setFrom($settingsData['smtp_user'], 'Orden de Pedido');
        $email->setTo($settingsData['email_new_order_sale_notification']);
        $email->setSubject($settingsData['nombre_comercial'] . $orderData['reference_no'] . ' | ' . $settingsData['nombre_comercial']);
        $email->setMessage($message); //your message here

        // $email->setCC('another@emailHere'); //CC
        // $email->setBCC('thirdEmail@emialHere'); // and BCC
        // $filename = '/img/yourPhoto.jpg'; //you can use the App patch
        // $email->attach($filename);

        $email->send();
        $email->printDebugger(['headers']);
    } catch (\Throwable $th) {
        return false;
        // throw $th;cd 
    }
}
function sendErrorLogEmail(string $errorDataFile, string $user, string $date,  $message = '')
{

    try {
        $settingsData = AppBackendSettings::getSettingsColumnsData([
            'mailpath',
            'protocol',
            'smtp_host',
            'smtp_user',
            'smtp_pass',
            'smtp_port',
            'smtp_crypto',
            'errors_mail',
        ]);

        $config = [
            'protocol' => $settingsData['protocol'],
            'mailPath' => $settingsData['mailpath'],
            'SMTPHost' => $settingsData['smtp_host'],
            'SMTPUser' => $settingsData['smtp_user'],
            'SMTPPass' => $settingsData['smtp_pass'],
            'SMTPPort' => $settingsData['smtp_port'],
            'SMTPCrypto' => $settingsData['smtp_crypto'],
            'charset'   => 'utf8'
        ];
        // echo $message;
        $email = \Config\Services::email();
        $email->initialize($config);
        $email->setFrom($settingsData['smtp_user'], 'Reporte de error WappsiPosApp');
        // echo $emailDir;
        $email->setTo($settingsData['errors_mail']);
        $email->setSubject('Reporte de errores en WappsiPosAPP por ' . $user);
        $email->setMessage('Error reportado por ' . $user . ' en la fecha ' . $date . "\n" . ($message ?? ''));
        //you can use the App patch

        $email->attach($errorDataFile);

        if($email->send()){
            return true;
        }else{
            return false;
        }
        $email->printDebugger(['headers']);
    } catch (\Throwable $th) {
        return false;
        // throw $th;
    }
}
