<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaOrderSalesModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_order_sales';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [
        "reference_no",
        "customer_id",
        "customer",
        "biller_id",
        "biller",
        "warehouse_id",
        "note",
        "staff_note",
        "total",
        "product_discount",
        "order_discount_id",
        "total_discount",
        "order_discount",
        "product_tax",
        "order_tax_id",
        "order_tax",
        "total_tax",
        "shipping",
        "grand_total",
        "sale_status",
        "payment_status",
        "payment_term",
        "due_date",
        "created_by",
        "updated_by",
        "updated_at",
        "total_items",
        "pos",
        "paid",
        "return_id",
        "surcharge",
        "attachment",
        "return_sale_ref",
        "sale_id",
        "return_sale_total",
        "rounding",
        "suspend_note",
        "api",
        "shop",
        "seller_id",
        "address_id",
        "reserve_id",
        "hash",
        "manual_payment",
        "cgst",
        "sgst",
        "igst",
        "payment_method",
        "pay_partner",
        "rete_fuente_percentage",
        "rete_fuente_total",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_total",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_total",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_total",
        "rete_other_account",
        "rete_other_base",
        "resolucion",
        "document_type_id",
        "destination_reference_no",
        "wms_picking_status",
        "delivery_day",
        "delivery_time_id",
        "wms_packing_status",
        "order_sale_origin",
        "last_update"
    ];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    // to app

    protected $allowedFieldsToApp       =[
        "id",
        "date",
        "reference_no",
        "customer_id",
        "customer",
        "biller_id",
        "biller",
        "warehouse_id",
        "note",
        "staff_note",
        "total",
        "product_discount",
        "order_discount_id",
        "total_discount",
        "order_discount",
        "product_tax",
        "order_tax_id",
        "order_tax",
        "total_tax",
        "shipping",
        "grand_total",
        "sale_status",
        "payment_status",
        "payment_term",
        "due_date",
        "created_by",
        "updated_by",
        "updated_at",
        "total_items",
        "pos",
        "paid",
        "return_id",
        "surcharge",
        "attachment",
        "return_sale_ref",
        "sale_id",
        "return_sale_total",
        "rounding",
        "suspend_note",
        "api",
        "shop",
        "seller_id",
        "address_id",
        "reserve_id",
        "hash",
        "manual_payment",
        "cgst",
        "sgst",
        "igst",
        "payment_method",
        "pay_partner",
        "rete_fuente_percentage",
        "rete_fuente_total",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_total",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_total",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_total",
        "rete_other_account",
        "rete_other_base",
        "resolucion",
        "document_type_id",
        "destination_reference_no",
        "registration_date",
        "wms_picking_status",
        "wms_packing_status", 
    ];
}
