<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaQuotesModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_quotes';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [

        "reference_no",
        "customer_id",
        "customer",
        "warehouse_id",
        "biller_id",
        "biller",
        "note",
        "internal_note",
        "total",
        "product_discount",
        "order_discount",
        "order_discount_id",
        "total_discount",
        "product_tax",
        "order_tax_id",
        "order_tax",
        "total_tax",
        "shipping",
        "grand_total",
        "status",
        "created_by",
        "updated_by",
        "updated_at",
        "attachment",
        "supplier_id",
        "supplier",
        "hash",
        "cgst",
        "sgst",
        "igst",
        "quote_currency",
        "quote_currency_trm",
        "quote_type",
        "rete_fuente_percentage",
        "rete_fuente_total",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_total",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_total",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_total",
        "rete_other_account",
        "rete_other_base",
        "rete_fuente_id",
        "rete_iva_id",
        "rete_ica_id",
        "rete_other_id",
        "address_id",
        "seller_id",
        "document_type_id",
        "destination_reference_no",
        "payment_status",
        "payment_term",
        "payment_method",

    ];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    // to app

    protected $allowedFieldsToApp       =[
        "id",
        "date",
        "reference_no",
        "customer_id",
        "customer",
        "warehouse_id",
        "biller_id",
        "biller",
        "note",
        "internal_note",
        "total",
        "product_discount",
        "order_discount",
        "order_discount_id",
        "total_discount",
        "product_tax",
        "order_tax_id",
        "order_tax",
        "total_tax",
        "shipping",
        "grand_total",
        "status",
        "created_by",
        "updated_by",
        "updated_at",
        "attachment",
        "supplier_id",
        "supplier",
        "hash",
        "cgst",
        "sgst",
        "igst",
        "quote_currency",
        "quote_currency_trm",
        "quote_type",
        "rete_fuente_percentage",
        "rete_fuente_total",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_total",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_total",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_total",
        "rete_other_account",
        "rete_other_base",
        "rete_fuente_id",
        "rete_iva_id",
        "rete_ica_id",
        "rete_other_id",
        "address_id",
        "seller_id",
        "document_type_id",
        "destination_reference_no",
        "payment_status",
        "payment_term",
        "payment_method",
    ];
}
