<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaUsersModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_users';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;

    // // fields
    // protected $username;
    // protected $password;

    protected $allowedFields        = [
        "username",
        "password",
        "first_name",
        "phone",
        "email",
        "last_name",
        "company_id",
        "group_id",
        "active",
        "seller_id",
        'biller_id',
        "gender",
        "warehouse_id",
        "document_type_id",
        "login_status",
        "host_url",
        "jwt_key",
        "company_folder",
        "pos_document_type_id", 
        "fe_pos_document_type_id",
    ];

    protected $allowedFieldsToApp        = [
        "username",
        "password",
        "first_name",
        "phone",
        "email",
        "last_name",
        "company_id",
        "group_id",
        "active",
        "seller_id",
        'biller_id',
        "gender",
        "warehouse_id",
        "fe_pos_document_type",
        "document_type_id",
        "login_status",
        "host_url",
        "jwt_key",
        "company_folder",
        "pos_document_type_id", 
        "fe_pos_document_type_id",
    ];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];
}
