<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Wappsi apis</title>
	<meta name="description" content="The small framework with powerful features">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="shortcut icon" type="image/png" href="/favicon.ico"/>

	<!-- STYLES -->

	<style {csp-style-nonce}>
		* {
			transition: background-color 300ms ease, color 300ms ease;
		}
		*:focus {
			background-color: rgba(221, 72, 20, .2);
			outline: none;
		}
		html, body {
			color: rgba(33, 37, 41, 1);
			font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji";
			font-size: 16px;
			margin: 0;
			padding: 0;
			-webkit-font-smoothing: antialiased;
			-moz-osx-font-smoothing: grayscale;
			text-rendering: optimizeLegibility;
		}
		header {
			background-color: rgba(247, 248, 249, 1);
			padding: .4rem 0 0;
		}
		.menu {
			padding: .4rem 2rem;
		}
		header ul {
			border-bottom: 1px solid rgba(242, 242, 242, 1);
			list-style-type: none;
			margin: 0;
			overflow: hidden;
			padding: 0;
			text-align: right;
		}
		header li {
			display: inline-block;
		}
		header li a {
			border-radius: 5px;
			color: rgba(0, 0, 0, .5);
			display: block;
			height: 44px;
			text-decoration: none;
		}
		header li.menu-item a {
			border-radius: 5px;
			margin: 5px 0;
			height: 38px;
			line-height: 36px;
			padding: .4rem .65rem;
			text-align: center;
		}
		header li.menu-item a:hover,
		header li.menu-item a:focus {
			background-color: rgba(221, 72, 20, .2);
			color: rgba(221, 72, 20, 1);
		}
		header .logo {
			float: left;
			height: 44px;
			padding: .4rem .5rem;
		}
		header .menu-toggle {
			display: none;
			float: right;
			font-size: 2rem;
			font-weight: bold;
		}
		header .menu-toggle button {
			background-color: rgba(221, 72, 20, .6);
			border: none;
			border-radius: 3px;
			color: rgba(255, 255, 255, 1);
			cursor: pointer;
			font: inherit;
			font-size: 1.3rem;
			height: 36px;
			padding: 0;
			margin: 11px 0;
			overflow: visible;
			width: 40px;
		}
		header .menu-toggle button:hover,
		header .menu-toggle button:focus {
			background-color: rgba(221, 72, 20, .8);
			color: rgba(255, 255, 255, .8);
		}
		header .heroe {
			margin: 0 auto;
			max-width: 1100px;
			padding: 1rem 1.75rem 1.75rem 1.75rem;
		}
		header .heroe h1 {
			font-size: 2.5rem;
			font-weight: 500;
		}
		header .heroe h2 {
			font-size: 1.5rem;
			font-weight: 300;
		}
		section {
			margin: 0 auto;
			max-width: 1100px;
			padding: 2.5rem 1.75rem 3.5rem 1.75rem;
		}
		section h1 {
			margin-bottom: 2.5rem;
		}
		section h2 {
			font-size: 120%;
			line-height: 2.5rem;
			padding-top: 1.5rem;
		}
		section pre {
			background-color: rgba(247, 248, 249, 1);
			border: 1px solid rgba(242, 242, 242, 1);
			display: block;
			font-size: .9rem;
			margin: 2rem 0;
			padding: 1rem 1.5rem;
			white-space: pre-wrap;
			word-break: break-all;
		}
		section code {
			display: block;
		}
		section a {
			color: rgba(221, 72, 20, 1);
		}
		section svg {
			margin-bottom: -5px;
			margin-right: 5px;
			width: 25px;
		}
		.further {
			background-color: rgba(247, 248, 249, 1);
			border-bottom: 1px solid rgba(242, 242, 242, 1);
			border-top: 1px solid rgba(242, 242, 242, 1);
		}
		.further h2:first-of-type {
			padding-top: 0;
		}
		footer {
			background-color: rgba(0, 125, 204, 1);
			text-align: center;
		}
		footer .environment {
			color: rgba(255, 255, 255, 1);
			padding: 2rem 1.75rem;
		}
		footer .copyrights {
			background-color: rgba(62, 62, 62, 1);
			color: rgba(200, 200, 200, 1);
			padding: .25rem 1.75rem;
		}
		@media (max-width: 559px) {
			header ul {
				padding: 0;
			}
			header .menu-toggle {
				padding: 0 1rem;
			}
			header .menu-item {
				background-color: rgba(244, 245, 246, 1);
				border-top: 1px solid rgba(242, 242, 242, 1);
				margin: 0 15px;
				width: calc(100% - 30px);
			}
			header .menu-toggle {
				display: block;
			}
			header .hidden {
				display: none;
			}
			header li.menu-item a {
				background-color: rgba(221, 72, 20, .1);
			}
			header li.menu-item a:hover,
			header li.menu-item a:focus {
				background-color: rgba(221, 72, 20, .7);
				color: rgba(255, 255, 255, .8);
			}
		}
	</style>
</head>
<body>

<!-- HEADER: MENU + HEROE SECTION -->
<header>

	<div class="menu">
		<ul>
			<li class="logo"><a href="https://www.wappsi.com.co/" target="_blank"><img height="44" title="CodeIgniter Logo"
																					alt="Visit CodeIgniter.com official website!"
																					src=" data:image/png;base64,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"></a>
			</li>
			<li class="menu-toggle">
				<button onclick="toggleMenu();">&#9776;</button>
			</li>
			<li class="menu-item hidden"><a href="https://www.wappsi.com.co/">Wappsi</a></li>
			<li class="menu-item hidden"><a href="#" target="_blank">Documentación</a>
			
		</ul>
	</div>

	<div class="heroe">

		<h1>Bienvenido a Wappsi-Apis</h1>

		<h2>Integración de multiples plataformas usando APIs</h2>

	</div>

</header>

<!-- CONTENT -->

<section>

	<h1>Acerca de esta pagina</h1>

	<p>Wappsi-Apis tiene como fin la integración de la plataforma existente de wappsi con distintas plataformas tales como Android o iOS, esto mediante el uso de una Interfaz de Programación de Aplicaciones API.</p>

	<p>Para obtener mas información acerca del uso de los endpoints revise la documentación.</p>


</section>

<div class="further">

	<section>

		<h1>Explorar</h1>

		<h2>
			<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'><rect x='32' y='96' width='64' height='368' rx='16' ry='16' style='fill:none;stroke:#000;stroke-linejoin:round;stroke-width:32px'/><line x1='112' y1='224' x2='240' y2='224' style='fill:none;stroke:#000;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px'/><line x1='112' y1='400' x2='240' y2='400' style='fill:none;stroke:#000;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px'/><rect x='112' y='160' width='128' height='304' rx='16' ry='16' style='fill:none;stroke:#000;stroke-linejoin:round;stroke-width:32px'/><rect x='256' y='48' width='96' height='416' rx='16' ry='16' style='fill:none;stroke:#000;stroke-linejoin:round;stroke-width:32px'/><path d='M422.46,96.11l-40.4,4.25c-11.12,1.17-19.18,11.57-17.93,23.1l34.92,321.59c1.26,11.53,11.37,20,22.49,18.84l40.4-4.25c11.12-1.17,19.18-11.57,17.93-23.1L445,115C443.69,103.42,433.58,94.94,422.46,96.11Z' style='fill:none;stroke:#000;stroke-linejoin:round;stroke-width:32px'/></svg>
			Conozca wappsi
		</h2>

		<p>Wappsi es un conjunto de soluciones y servicios  que permite controlar y optimizar todos los procesos en su empresa de forma fácil y práctica. Funciona "en la nube", es decir, para trabajar solo necesita una conexión a internet y un computador, tablet o teléfono inteligente. <a href="https://www.wappsi.com.co/"
			target="_blank">Wappsi</a> !</p>

		<h2>
			<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 512 512'><path d='M431,320.6c-1-3.6,1.2-8.6,3.3-12.2a33.68,33.68,0,0,1,2.1-3.1A162,162,0,0,0,464,215c.3-92.2-77.5-167-173.7-167C206.4,48,136.4,105.1,120,180.9a160.7,160.7,0,0,0-3.7,34.2c0,92.3,74.8,169.1,171,169.1,15.3,0,35.9-4.6,47.2-7.7s22.5-7.2,25.4-8.3a26.44,26.44,0,0,1,9.3-1.7,26,26,0,0,1,10.1,2L436,388.6a13.52,13.52,0,0,0,3.9,1,8,8,0,0,0,8-8,12.85,12.85,0,0,0-.5-2.7Z' style='fill:none;stroke:#000;stroke-linecap:round;stroke-miterlimit:10;stroke-width:32px'/><path d='M66.46,232a146.23,146.23,0,0,0,6.39,152.67c2.31,3.49,3.61,6.19,3.21,8s-11.93,61.87-11.93,61.87a8,8,0,0,0,2.71,7.68A8.17,8.17,0,0,0,72,464a7.26,7.26,0,0,0,2.91-.6l56.21-22a15.7,15.7,0,0,1,12,.2c18.94,7.38,39.88,12,60.83,12A159.21,159.21,0,0,0,284,432.11' style='fill:none;stroke:#000;stroke-linecap:round;stroke-miterlimit:10;stroke-width:32px'/></svg>
			Explore las novedades
		</h2>

		<p>Somos una compañía obsesionada por el desarrollo de aplicaciones móviles y web, que permiten controlar y optimizar los procesos en los emprendimientos y empresas de nuestros clientes, para estar al tanto de las novedades visite <a href="https://es-la.facebook.com/wappsico/"
			 target="_blank">Wappsi Colombia</a> !</p>


	</section>

</div>

<!-- FOOTER: DEBUG INFO + COPYRIGHTS -->

<footer>
	<div class="environment">

		<p>Pagina renderizada en {elapsed_time} segundos</p>

		<p>Entorno: <?= ENVIRONMENT ?></p>

	</div>

	<div class="copyrights">

		<p>&copy; <?= date('Y') ?> Developed in Codeigniter <?= CodeIgniter\CodeIgniter::CI_VERSION ?>, CodeIgniter Foundation. CodeIgniter is open source project released under the MIT
			open source licence.</p>

	</div>

</footer>

<!-- SCRIPTS -->

<script>
	function toggleMenu() {
		var menuItems = document.getElementsByClassName('menu-item');
		for (var i = 0; i < menuItems.length; i++) {
			var menuItem = menuItems[i];
			menuItem.classList.toggle("hidden");
		}
	}
</script>

<!-- -->

</body>
</html>
