<?php

namespace Config;

use CodeIgniter\Database\Config;

/**
 * Database Configuration
 */
class Database extends Config
{
    /**
     * The directory that holds the Migrations
     * and Seeds directories.
     */
    public string $filesPath = APPPATH . 'Database' . DIRECTORY_SEPARATOR;

    /**
     * Lets you choose which connection group to
     * use if no other is specified.
     */
    public string $defaultGroup = 'default';

    /**
     * Base database conection params
     *
     * @return array
     */
    public function baseData(array $baseData)
    {
        return [
            'DSN'      => '',
            'hostname' => $baseData['hostname'],
            'username' => $baseData['username'],
            'password' => $baseData['password'],
            'database' => $baseData['database'],
            'DBDriver' => 'MySQLi',
            'DBPrefix' => '',
            'pConnect' => false,
            'DBDebug'  => (ENVIRONMENT !== 'production'),
            'cacheOn'  => false,
            'cacheDir' => '',
            'charset'  => 'utf8',
            'DBCollat' => 'utf8_general_ci',
            'swapPre'  => '',
            'encrypt'  => false,
            'compress' => false,
            'strictOn' => false,
            'failover' => [],
            'port'     => 3306,
        ];
    }

    /**
     * The default database connection.
     */
    public array $default = [
        'DSN'      => '',
        'hostname' => 'localhost',
        'username' => '',
        'password' => '',
        'database' => '',
        'DBDriver' => 'MySQLi',
        'DBPrefix' => '',
        'pConnect' => false,
        'DBDebug'  => true,
        'charset'  => 'utf8',
        'DBCollat' => 'utf8_general_ci',
        'swapPre'  => '',
        'encrypt'  => false,
        'compress' => false,
        'strictOn' => false,
        'failover' => [],
        'port'     => 3306,
    ];

    /**
     * This database connection is used when
     * running PHPUnit database tests.
     */
    public array $tests = [
        'DSN'         => '',
        'hostname'    => '127.0.0.1',
        'username'    => '',
        'password'    => '',
        'database'    => ':memory:',
        'DBDriver'    => 'SQLite3',
        'DBPrefix'    => 'db_',  // Needed to ensure we're working correctly with prefixes live. DO NOT REMOVE FOR CI DEVS
        'pConnect'    => false,
        'DBDebug'     => true,
        'charset'     => 'utf8',
        'DBCollat'    => 'utf8_general_ci',
        'swapPre'     => '',
        'encrypt'     => false,
        'compress'    => false,
        'strictOn'    => false,
        'failover'    => [],
        'port'        => 3306,
        'foreignKeys' => true,
        'busyTimeout' => 1000,
    ];

    /**
     * This database connection is used for dulcelandia users.
     *
     * @var array
     */

    public $dulcelandia = [];

    /**
     * This database connection is used for wappsi global db.
     *
     * @var array
     */

    public $wappsi = [];

    /**
     * Conexion a multiabastos prueba.
     *
     * @var array
     */

    public $multiprueba = [];

    /**
     * Conexion a Zafra Produccion.
     *
     * @var array
     */

    public $zafra = [];


    /**
     * Conexion a rusbel Produccion.
     *
     * @var array
     */

    public $rusbel = [];


    /**
     * Conexion a envax Produccion.
     *
     * @var array
     */

    public $envax = [];


    /**
     * Conexion a puma Produccion.
     *
     * @var array
     */

    public $puma = [];

    public function __construct()
    {
        // /// This is wappsiDB

        $this->wappsi =  $this->baseData(
            Services::getCustomDBParams('wappsi')
        );

        $this->dulcelandia = $this->baseData(
            Services::getCustomDBParams('dulcelandia')
        );

        $this->multiprueba = $this->baseData(
            Services::getCustomDBParams('multiprueba')
        );

        $this->zafra = $this->baseData(
            Services::getCustomDBParams('zafra')
        );

        $this->envax = $this->baseData(
            Services::getCustomDBParams('envax')
        );

        $this->rusbel = $this->baseData(
            Services::getCustomDBParams('rusbel')
        );

        $this->puma = $this->baseData(
            Services::getCustomDBParams('puma')
        );
        
        parent::__construct();

        // Ensure that we always set the database group to 'tests' if
        // we are currently running an automated test suite, so that
        // we don't overwrite live data on accident.
        if (ENVIRONMENT === 'testing') {
            $this->defaultGroup = 'tests';
        }
    }
}
