<?php
/**
 * settings table's controller.
 *
 * Used to perform operations on settings table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;



use App\Models\AppBackendSettingsModel;
use CodeIgniter\RESTful\ResourceController;

class AppBackendSettings extends ResourceController
{
    /**
     * Returns selected data in sma_settings, $column field is a string who 
     * determines wich column to return
     *
     * @param string $columns
     * @return string|int|null
     */
    static public function getSettingsColumnsData($columns)
    {
        $sModel = new AppBackendSettingsModel();
        $data = $sModel->select($columns)
            ->first();
        return $data;
    }

}