<?php
/**
 * biller_documents_types table's controller
 *
 * Used to perform operations on biller_documents_types table
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/

namespace App\Controllers;



use App\Models\SmaBillerDocumentsTypesModel;
use CodeIgniter\RESTful\ResourceController;

class SmaBillerDocumentsTypes extends ResourceController
{

    /**
     * Get biller_documents_types rows
     *
     * For a given biller_id value on request, returns biller_documents_types related rows
     *
     * @return  HttpResponse
    */
    public function sync(){

        $this->setModel(new SmaBillerDocumentsTypesModel($this->dbGroupFromRequest()));

        $rules = [
            'biller_id'=> 'required',
        ];
        $this->request;
        $message = [
        
            'biller_id' => [
                'required' => 'Debe suministrar el biller_id a usar para filtrar los registros',
            ]
        ];


        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $list = [];

            if($this->request->getVar('biller_id')!=0){

   
                $list = $this->getBillerDocumentData($this->request->getVar('biller_id'));



                $response = [
                    'status' => 200,
                    'error' => false,
                    'message' => 'Exito',
                    'server_date_time'=> $this->getServerDateTime(),
                    'data' => $list
                ];
    
                return $this->respondCreated($response);
            }else{
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'biller_id invalido',
                    'server_date_time'=> '',
                    'data' => []
                ];
    
                return $this->respondCreated($response);
            }

        }

    }

    /**
	 * Biller documents data
     * 
     * For a given biller id, returns selected columns data from biller_documents_types
     * 
     * @param int  $id   biller_id 
     * @return array If empty array, there is no data found.
	 */
    public function getBillerDocumentData($id){

        // $mysqltime = date ('Y-m-d H:i:s', $this->request->getVar('last_sync'));
        $rows_list = $this->model->getSelectedRows(['biller_id'=>$id]);

        return $rows_list;
    }

}