<?php
/**
 * permissions table's controller.
 *
 * Used to perform operations on permissions table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;



use App\Models\SmaPermissionsModel;
use CodeIgniter\RESTful\ResourceController;

class SmaPermissions extends ResourceController
{

     /**
     * Returns selected permissions data for a given group_id
     *
     * @param int $group_id
     * @return object|null
     */
    static public function getGroupPermissions($group_id,String $dbGroup)
    {
        $model = new SmaPermissionsModel($dbGroup);
        $res = $model->select($model->getColumnsString())
            ->where('group_id', $group_id)
            ->first();
        // print_r($res);
        return $res;
    }

}