<?php
/**
 * pos_register_movements table's controller.
 *
 * Used to perform operations on pos_register_movements table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;

use App\Validation\SmaPosRegisterMovementsValidation;
use Config\Services;

// use App\Models\SmaPosRegisterMovementsModel;
use CodeIgniter\RESTful\ResourceController;

class SmaPosRegisterMovements extends ResourceController
{

    /**
     * Create a new movement for a opened pos_register.
     *
     * Given movement data on request, create a new movement for user who 
     * generate the request.
     * 
     * 
     * Validation rules and messages are taken from SmaPosRegisterMovementsValidation file.
     *
     * @filesource App/Validation/SmaPosRegisterMovementsValidation
     *
     * @return  HttpResponse
    */
    public function newMovement()
    {

        $rules = SmaPosRegisterMovementsValidation::newMovementRules();
        $message = SmaPosRegisterMovementsValidation::newMovementMessages();;

        // echo $this->request->();
        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
            ];

            return $this->respondCreated($response);
        } else {
            $movement = $this->request->getJSON();
            $movement->{'from_app'} = true;
            // $movement->{csrf_token()} = csrf_hash();;
            $movement = json_encode($movement);
            $movement = json_decode($movement, true);
            helper('jwt');
            $authHeader = $this->request->getServer('HTTP_AUTHORIZATION');
            $token = getJWTFromRequest($authHeader);
            $company_url = companyURLFromJWT($token);
            $wappsi_web_endp = Services::getWappsiWebRegisterEndpoint();

            //build url
            $url = Services::buildURL($company_url,$wappsi_web_endp);
            // send movement to Henrry's function
            $regMovement = $this->httpGETXform($url, $movement);
            // remove "
            $regMovement = $this->renameKey(json_decode($regMovement), "\"", '');

            $regMovement['error'] == 1 ? $regMovement['error'] = true : $regMovement['error'] = false;
            // print_r($movement);
            // print_r($regMovement);

            if ($regMovement['error'] ?? true) {
                $response = [
                    'status' => 401,
                    'error' => true,
                    'sync'  => false,
                    'message' => $regMovement['message']??'',
                    'data' => $regMovement['error']??[]
                ];
            } else {
                $response = [
                    'status' => 201,
                    'error' => false,
                    'sync'  => false,
                    'message' => $regMovement['message']??'',
                    'data' => $regMovement['error']??[]
                ];
            }

            $response = $regMovement;

            return $this->respondCreated($response);
        }
    }
}
