<?php

namespace App\Controllers;



use App\Models\SmaSubzonesModel;
use CodeIgniter\RESTful\ResourceController;

class SmaSubzones extends ResourceController
{
    
    /**
     * Get zone subzones.
     *
     * Given zone_code on request, return al subzones for zone_code.
     *
     * @return  HttpResponse
    */
    public function getZoneSubzones(){

        

        $rules = [
            'zone_id' => 'required'
        ];
        $message = [
            'zone_id' => [
                'required' => 'Id de zona requerido',
            ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails


            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $this->setModel(new SmaSubzonesModel($this->dbGroupFromRequest()));
            
            $data = $this->model->join("sma_zones",'sma_zones.id='.$this->request->getVar("zone_id").' AND sma_subzones.zone_code=sma_zones.zone_code')
                    ->get();
            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                "data"=>$data->getResult()
            ];

            return $this->respondCreated($response);

        }

    }

    /**
     * Get subzone info.
     *
     * Given a subzone_code, return it's data if exist.
     * 
     * 
     * @param int  $subzone_id
     * 
     * @return array 
    */
    static public function getSubzoneInfo($subzone_id,$dbGroup){
        $model = new SmaSubzonesModel($dbGroup);

        return $model->where("id",$subzone_id)->first();
    }


}