<?php
/**
 * units table's controller.
 *
 * Used to perform operations on units table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;



use App\Models\SmaUnitsModel;
use CodeIgniter\RESTful\ResourceController;

class SmaUnits extends ResourceController
{
    
    /**
     * Get updated units table's rows.
     *
     * 
     * Based on last_sync value (from request), return updated rows from units.
     *
     * Request should contain last_sync value (date) to get updated rows based on
     * that date.
     *
     * If request contains first_time = true, it returns all data in table.
     *
     *
     * @return HttpResponse 
    */
    public function sync(){

        $this->setModel(new SmaUnitsModel($this->dbGroupFromRequest()));

        $rules = [
            'last_sync' => 'valid_date'
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $list = [];

            if($this->request->getVar('first_time')==true){

   
                $list = $this->getAllRows(['id'=>'id_cloud']);



            }else if($this->request->getVar('first_time')==false){
                $list = $this->getUpdatedRows(['id'=>'id_cloud']);
            }else{
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'EL campo "first_time" no es valido',
                    'data' => []
                ];
    
                return $this->respondCreated($response);
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time'=> $this->getServerDateTime(),
                'data' => $list
            ];

            return $this->respondCreated($response);

        }

    }

     /**
     * Returns selected data in sma_companies, $column field is a string for select
     * who determines wich column return
     *
     * @param int $ids
     * @return object|null
     */
    static public function getProductUnit($id,$dbGroup)
    {
        $model = new SmaUnitsModel($dbGroup);
        $res = $model->select($model->getColumnsString())
            ->where('id', $id)
            ->first();
        // print_r($res);
        return $res;
    }

    /**
     * Returns selected data in sma_companies, $column field is a string for select
     * who determines wich column return
     *
     * @param int $ids
     * @return array|null
     */
    static public function getProductUnitWithBaseUnitData($id,$dbGroup)
    {
        $model = new SmaUnitsModel($dbGroup);
        $res = $model->select('bunit.code as base_unit_code, unit.*')
            ->from('sma_units as unit')
            ->where('unit.id', $id)
            ->join('sma_units as bunit','unit.base_unit = bunit.id')
            ->first();
        // print_r($res);
        return $res;
    }

}