<?php

declare(strict_types=1);

namespace CodeIgniter\Shield\Database\Migrations;

use CodeIgniter\Database\Forge;
use CodeIgniter\Database\Migration;

class CreateErrorsReport extends Migration
{


    public function __construct(?Forge $forge = null)
    {
        parent::__construct($forge);
    }

    public function up(): void
    {
        // Users Table
        $this->forge->addField([
            'id'             => ['type' => 'int', 'constraint' => 11, 'unsigned' => true, 'auto_increment' => true],
            'client'       => ['type' => 'varchar', 'constraint' => 30, 'null' => true],
            'user_id'       => ['type' => 'varchar', 'constraint' => 30, 'null' => true],
            'error'         => ['type' => 'varchar', 'null' => true],
            'user_message' => ['type' => 'varchar', 'constraint' => 255, 'null' => true],
            'created_at'     => ['type' => 'datetime', 'null' => true],
            'updated_at'     => ['type' => 'datetime', 'null' => true],
            'deleted_at'     => ['type' => 'datetime', 'null' => true],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('errors_reports');
    }

    // --------------------------------------------------------------------

    public function down(): void
    {
        $this->db->disableForeignKeyChecks();

        $this->forge->dropTable('errors_reports', true);

        $this->db->enableForeignKeyChecks();
    }
}
