<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaPermissionsModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_permissions';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    protected $allowedFieldsToApp       = [
        "products-index",
        "products-add",
        "products-edit",
        "products-price",
        "sales-index",
        "sales-add",
        "purchases-index",
        "purchases-add",
        "transfers-index",
        "transfers-add",
        "customers-index",
        "customers-add",
        "customers-edit",
        "suppliers-add",
        "suppliers-index",
        "suppliers-edit",
        "sales-deliveries",
        "sales-add_delivery",
        "sales-edit_delivery",
        "pos-index",
        "pos-sales",
        "sales-orders",
        "sales-add_order",
        "quotes-index",
        "quotes-add",
        "pos-pos_register_movements",
        "pos-pos_register_add_movement"
    ];
    
    
    
}
