<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaProductsModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_products';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [
        "promotion",
        "promo_price",
        "start_date",
        "end_date",
    ];

    

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];


    protected $allowedFieldsToApp       = [
        "id",
        "code",
        "name",
        "unit",
        "cost",
        "avg_cost",
        "price",
        "alert_quantity",
        "image",
        "category_id",
        "subcategory_id",
        "cf1",
        "cf2",
        "cf3",
        "cf4",
        "cf5",
        "cf6",
        "quantity",
        "tax_rate",
        "track_quantity",
        "details",
        "warehouse",
        "barcode_symbology",
        "file",
        "product_details",
        "tax_method",
        "type",
        "supplier1",
        "supplier1price",
        "supplier2",
        "supplier2price",
        "supplier3",
        "supplier3price",
        "supplier4",
        "supplier4price",
        "supplier5",
        "supplier5price",
        "promotion",
        "promo_price",
        "start_date",
        "end_date",
        "supplier1_part_no",
        "supplier2_part_no",
        "supplier3_part_no",
        "supplier4_part_no",
        "supplier5_part_no",
        "sale_unit",
        "purchase_unit",
        "brand",
        "slug",
        "featured",
        "weight",
        "hsn_code",
        "views",
        // "hide_detal",
        // "hide_pos",
        // "hide_online_store",
        "second_name",
        "reference",
        "has_multiple_units",
        "profitability_margin",
        "ignore_hide_parameters",
        "consumption_sale_tax",
        "consumption_purchase_tax",
        "discontinued",
        "attributes",
        "supplier1price_date",
        "supplier2price_date",
        "supplier3price_date",
        "supplier4price_date",
        "supplier5price_date",
        "registration_date",
        "last_update",
    ];
    
    
}
