<?php

namespace App\Controllers;


use CodeIgniter\RESTful\ResourceController;

class Errors extends ResourceController
{
    

    public function index()
    {
        //
    }

    public function logError(){


        $rules = [
            'errors_info' => 'required',
            'message' => 'string|required',
            'user_data' => 'string|required'
        ];
        $this->request;
        $message = [
            // 'errors_info' => [
            //     'required' => 'Tipo de dato no valido',
            // ],
            'message' => [
                'string' => 'El mensaje de error debe ser un string'
            ],
            'user_data' => [
                'string' => 'Debe especificar el usuario que genera el reporte'
            ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => []
            ];

            return $this->respondCreated($response);
            
        } else {
            // $errorData=$this->request->getVar('errors_info');
            $userData=$this->request->getVar('user_data');
            $message=$this->request->getVar('message');
            $errorData=$this->request->getJSON(true);
            $date = date('d-m-y h:i:s');
            // validate
            helper('array_to_csv');
            $errorLogDir = array_To_CSV($errorData['errors_info']); 
            helper('email');
            sendErrorLogEmail($errorLogDir,$userData,$date,$message,);
            
            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Reporte de errores exitoso',
                'server_date_time'=> $date
            ];

            return $this->respondCreated($response);

        }

    }

}