<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaPaymentsModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_payments';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    protected $allowedFieldsToApp       = [
        "id",
        "date",
        "sale_id",
        "return_id",
        "purchase_id",
        "expense_id",
        "reference_no",
        "transaction_id",
        "paid_by",
        "cheque_no",
        "cc_no",
        "cc_holder",
        "cc_month",
        "cc_year",
        "cc_type",
        "amount",
        "currency",
        "created_by",
        "attachment",
        "type",
        "note",
        "pos_paid",
        "pos_balance",
        "approval_code",
        "affect",
        "trm_difference",
        "trm_difference_ledger_id",
        "tax_rate_traslate",
        "tax_rate_traslate_ledger_id",
        "cost_center_id",
        "rete_fuente_total",
        "rete_iva_total",
        "rete_ica_total",
        "rete_other_total",
        "multi_payment",
        "mean_payment_code_fe",
        "payment_date",
        "consecutive_payment",
        "document_type_id",
        "rete_fuente_percentage",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_account",
        "rete_other_base",
        "rete_fuente_id",
        "rete_iva_id",
        "rete_ica_id",
        "rete_other_id",
        "discount_ledger_id",
        "comm_perc",
        "comm_base",
        "comm_amount",
        "seller_id",
        "comm_payment_status",
        "comm_payment_date",
        "comm_payment_reference_no",
        "concept_ledger_id",
        "affected_deposit_id",
        "return_reference_no",
        "pm_commision_value",
        "pm_retefuente_value",
        "pm_reteiva_value",
        "pm_reteica_value",
        "company_id",
        "rete_fuente_assumed",
        "rete_iva_assumed",
        "rete_ica_assumed",
        "rete_other_assumed",
        "rete_fuente_assumed_account",
        "rete_iva_assumed_account",
        "rete_ica_assumed_account",
        "rete_other_assumed_account",
        "concept_base",
        "concept_company_id",
        "rete_bomberil_percentage",
        "rete_bomberil_total",
        "rete_bomberil_account",
        "rete_bomberil_base",
        "rete_autoaviso_percentage",
        "rete_autoaviso_total",
        "rete_autoaviso_account",
        "rete_autoaviso_base",
        "rete_bomberil_id",
        "rete_autoaviso_id",
        "rete_bomberil_assumed_account",
        "rete_autoaviso_assumed_account",
        "comm_paid_payments_ids",
        "comm_paid_sale_reference"
    ];
    
    
    
}
