<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaPosSettingsModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_pos_settings';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    protected $allowedFieldsToApp       = [
        "pos_id",
        "cat_limit",
        "pro_limit",
        "default_section",
        "default_customer",
        "default_biller",
        "display_time",
        "cf_title1",
        "cf_title2",
        "cf_value1",
        "cf_value2",
        "receipt_printer",
        "cash_drawer_codes",
        "focus_add_item",
        "add_manual_product",
        "customer_selection",
        'uvt_value',
        'activate_electronic_pos',
        "add_customer",
        "toggle_category_slider",
        "toggle_subcategory_slider",
        "cancel_sale",
        "suspend_sale",
        "print_items_list",
        "finalize_sale",
        "today_sale",
        "open_hold_bills",
        "close_register",
        "keyboard",
        "pos_printers",
        "java_applet",
        "product_button_color",
        "tooltips",
        "paypal_pro",
        "stripe",
        "rounding",
        "char_per_line",
        "pin_code",
        "purchase_code",
        "envato_username",
        "version",
        "after_sale_page",
        "item_order",
        "authorize",
        "toggle_brands_slider",
        "remote_printing",
        "printer",
        "order_printers",
        "auto_print",
        "customer_details",
        "local_printers",
        "balance_settings",
        "balance_label_prefix",
        "time_focus_quantity",
        "restobar_mode",
        "table_service",
        "order_print_mode",
        "apply_suggested_tip",
        "apply_suggested_home_delivery_amount",
        "home_delivery_in_invoice",
        "cloud_print_mail",
        "cloud_print_service_name",
        "cloud_print_json_name",
        "printer_selected_direct_printing",
        "detail_sale_by_category",
        "show_suspended_bills_automatically",
        "print_voucher_delivery",
        "allow_print_command",
        "express_payment",
        "search_product_price",
        "except_tip_restobar",
        "required_shipping_restobar",
        "mobile_print_automatically_invoice",
        "use_barcode_scanner",
        "show_variants_and_preferences",
        "order_to_table_default_restobar",
        "mobile_print_wait_time",
        "show_client_modal_on_select",
        "last_update"
    ];
    

}
