<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaPurchaseItemsModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_purchase_items';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [
        "purchase_id",
        "transfer_id",
        "product_id",
        "product_code",
        "product_name",
        "option_id",
        "net_unit_cost",
        "quantity",
        "warehouse_id",
        "item_tax",
        "tax_rate_id",
        "tax",
        "item_tax_2",
        "tax_rate_2_id",
        "tax_2",
        "discount",
        "item_discount",
        "expiry",
        "subtotal",
        "quantity_balance",
        "date",
        "status",
        "unit_cost",
        "real_unit_cost",
        "quantity_received",
        "supplier_part_no",
        "purchase_item_id",
        "product_unit_id",
        "product_unit_code",
        "unit_quantity",
        "serial_no",
        "gst",
        "cgst",
        "sgst",
        "igst",
        "product_unit_id_selected",
        "shipping_unit_cost",
        "profitability_margin",
        "consumption_purchase",
        "returned_quantity",
        "registration_date",
        "expense_category_creditor_ledger_id",
        "calculated_avg_cost",
    ];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    // to app

    protected $allowedFieldsToApp       =[
        "id",
        "purchase_id",
        "transfer_id",
        "product_id",
        "product_code",
        "product_name",
        "option_id",
        "net_unit_cost",
        "quantity",
        "warehouse_id",
        "item_tax",
        "tax_rate_id",
        "tax",
        "item_tax_2",
        "tax_rate_2_id",
        "tax_2",
        "discount",
        "item_discount",
        "expiry",
        "subtotal",
        "quantity_balance",
        "date",
        "status",
        "unit_cost",
        "real_unit_cost",
        "quantity_received",
        "supplier_part_no",
        "purchase_item_id",
        "product_unit_id",
        "product_unit_code",
        "unit_quantity",
        "serial_no",
        "gst",
        "cgst",
        "sgst",
        "igst",
        "product_unit_id_selected",
        "shipping_unit_cost",
        "profitability_margin",
        "consumption_purchase",
        "returned_quantity",
        "registration_date",
        "expense_category_creditor_ledger_id",
        "calculated_avg_cost",
    ];
}
