<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaPurchasesModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup = 'default';
    protected $table = 'sma_purchases';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $insertID = 0;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $protectFields = true;
    protected $allowedFields = [
        "reference_no",
        "date",
        "supplier_id",
        "supplier",
        "warehouse_id",
        "note",
        "total",
        "product_discount",
        "order_discount_id",
        "order_discount",
        "total_discount",
        "product_tax",
        "order_tax_id",
        "order_tax",
        "total_tax",
        "shipping",
        "grand_total",
        "paid",
        "status",
        "payment_status",
        "created_by",
        "updated_by",
        "updated_at",
        "attachment",
        "payment_term",
        "due_date",
        "return_id",
        "surcharge",
        "return_purchase_ref",
        "purchase_id",
        "return_purchase_total",
        "cgst",
        "sgst",
        "igst",
        "closed_year",
        "rete_fuente_percentage",
        "rete_fuente_total",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_total",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_total",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_total",
        "rete_other_account",
        "rete_other_base",
        "order_discount_method",
        "purchase_currency",
        "purchase_currency_trm",
        "purchase_type",
        "credit_ledger_id",
        "payment_affects_register",
        "cost_center_id",
        "biller_id",
        "consecutive_supplier",
        "document_type_id",
        "rete_fuente_id",
        "rete_iva_id",
        "rete_ica_id",
        "rete_other_id",
        "purchase_origin",
        "purchase_origin_reference_no",
        "prorated_shipping_cost",
        "consumption_purchase",
        "resolucion",
        "due_payment_method_id",
        "registration_date",
        "expense_causation",
        "return_other_concepts",
        "rete_fuente_assumed",
        "rete_iva_assumed",
        "rete_ica_assumed",
        "rete_other_assumed",
        "rete_fuente_assumed_account",
        "rete_iva_assumed_account",
        "rete_ica_assumed_account",
        "rete_other_assumed_account",
        "rete_bomberil_percentage",
        "rete_bomberil_total",
        "rete_bomberil_account",
        "rete_bomberil_base",
        "rete_autoaviso_percentage",
        "rete_autoaviso_total",
        "rete_autoaviso_account",
        "rete_autoaviso_base",
        "rete_bomberil_id",
        "rete_autoaviso_id",
        "rete_bomberil_assumed_account",
        "rete_autoaviso_assumed_account",
    ];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat = 'datetime';
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    protected $deletedField = 'deleted_at';

    // Validation
    protected $validationRules = [];
    protected $validationMessages = [];
    protected $skipValidation = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert = [];
    protected $afterInsert = [];
    protected $beforeUpdate = [];
    protected $afterUpdate = [];
    protected $beforeFind = [];
    protected $afterFind = [];
    protected $beforeDelete = [];
    protected $afterDelete = [];

    protected $allowedFieldsToApp = [
        "id",
        "reference_no",
        "date",
        "supplier_id",
        "supplier",
        "warehouse_id",
        "note",
        "total",
        "product_discount",
        "order_discount_id",
        "order_discount",
        "total_discount",
        "product_tax",
        "order_tax_id",
        "order_tax",
        "total_tax",
        "shipping",
        "grand_total",
        "paid",
        "status",
        "payment_status",
        "created_by",
        "updated_by",
        "updated_at",
        "attachment",
        "payment_term",
        "due_date",
        "return_id",
        "surcharge",
        "return_purchase_ref",
        "purchase_id",
        "return_purchase_total",
        "cgst",
        "sgst",
        "igst",
        "closed_year",
        "rete_fuente_percentage",
        "rete_fuente_total",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_total",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_total",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_total",
        "rete_other_account",
        "rete_other_base",
        "order_discount_method",
        "purchase_currency",
        "purchase_currency_trm",
        "purchase_type",
        "credit_ledger_id",
        "payment_affects_register",
        "cost_center_id",
        "biller_id",
        "consecutive_supplier",
        "document_type_id",
        "rete_fuente_id",
        "rete_iva_id",
        "rete_ica_id",
        "rete_other_id",
        "purchase_origin",
        "purchase_origin_reference_no",
        "prorated_shipping_cost",
        "consumption_purchase",
        "resolucion",
        "due_payment_method_id",
        "registration_date",
        "expense_causation",
        "return_other_concepts",
        "rete_fuente_assumed",
        "rete_iva_assumed",
        "rete_ica_assumed",
        "rete_other_assumed",
        "rete_fuente_assumed_account",
        "rete_iva_assumed_account",
        "rete_ica_assumed_account",
        "rete_other_assumed_account",
        "rete_bomberil_percentage",
        "rete_bomberil_total",
        "rete_bomberil_account",
        "rete_bomberil_base",
        "rete_autoaviso_percentage",
        "rete_autoaviso_total",
        "rete_autoaviso_account",
        "rete_autoaviso_base",
        "rete_bomberil_id",
        "rete_autoaviso_id",
        "rete_bomberil_assumed_account",
        "rete_autoaviso_assumed_account",
    ];
}
