<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaSettingsModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_settings';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [

        'id',
        'ip_address',
        'login',
        'time'

    ];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];
    
    protected $allowedFieldsToApp       = [
        "setting_id",
        "logo",
        "logo2",
        "site_name",
        "language",
        "default_warehouse",
        "accounting_method",
        "default_currency",
        "default_tax_rate",
        "rows_per_page",
        "version",
        "default_tax_rate2",
        "dateformat",
        "sales_prefix",
        "quote_prefix",
        "quote_purchase_prefix",
        "order_sale_prefix",
        "purchase_prefix",
        "transfer_prefix",
        "delivery_prefix",
        "payment_prefix",
        "return_prefix",
        "returnp_prefix",
        "expense_prefix",
        "item_addition",
        "theme",
        "product_serial",
        "default_discount",
        "product_discount",
        "discount_method",
        "tax1",
        "tax2",
        "tax3",
        "overselling",
        "restrict_user",
        "restrict_calendar",
        "timezone",
        "iwidth",
        "iheight",
        "twidth",
        "theight",
        "watermark",
        "reg_ver",
        "allow_reg",
        "reg_notification",
        "auto_reg",
        "protocol",
        "mailpath",
        "smtp_host",
        "smtp_user",
        "smtp_pass",
        "smtp_port",
        "smtp_crypto",
        "corn",
        "customer_group",
        "default_email",
        "mmode",
        "bc_fix",
        "auto_detect_barcode",
        "captcha",
        "reference_format",
        "racks",
        "attributes",
        "product_expiry",
        "decimals",
        "qty_decimals",
        "decimals_sep",
        "thousands_sep",
        "invoice_view",
        "default_biller",
        "envato_username",
        "purchase_code",
        "rtl",
        "each_spent",
        "ca_point",
        "each_sale",
        "sa_point",
        "`update`",
        "sac",
        "display_all_products",
        "display_symbol",
        "symbol",
        "remove_expired",
        "barcode_separator",
        "set_focus",
        "price_group",
        "barcode_img",
        "ppayment_prefix",
        "disable_editing",
        "qa_prefix",
        "update_cost",
        "apis",
        "pdf_lib",
        "state",
        "sma_payment_prefix",
        "deposit_prefix",
        "cashier_close",
        "alert_sale_expired",
        "tipo_regimen",
        "purchase_tax_rate",
        "modulary",
        "resolucion_porc_aviso",
        "resolucion_dias_aviso",
        "prioridad_precios_producto",
        "descuento_orden",
        "allow_change_sale_iva",
        "tax_rate_traslate",
        "get_companies_check_digit",
        "tipo_persona",
        "tipo_documento",
        "digito_verificacion",
        "numero_documento",
        "razon_social",
        "nombre_comercial",
        "primer_nombre",
        "segundo_nombre",
        "primer_apellido",
        "segundo_apellido",
        "matricula_mercantil",
        "direccion",
        "localidad",
        "postal_code",
        "ciudad",
        "city_code",
        "departamento",
        "pais",
        "allow_advanced_search",
        "rounding",
        "purchase_payment_affects_cash_register",
        "digital_signature",
        "max_num_results_display",
        "cost_center_selection",
        "hide_products_in_zero_price",
        "default_cost_center",
        "tax_rate_translate",
        "electronic_billing",
        "fe_technology_provider",
        "fe_user",
        "fe_password",
        "tax_method",
        "show_alert_sale_expired",
        "customer_default_country",
        "customer_default_state",
        "customer_default_city",
        "set_adjustment_cost",
        "default_records_filter",
        "show_brand_in_product_search",
        "close_year_step",
        "closed_from_another_year",
        "precios_por_unidad_presentacion",
        "lock_cost_field_in_product",
        "fuente_retainer",
        "iva_retainer",
        "ica_retainer",
        "export_to_csv_each_new_customer",
        "commision_payment_method",
        "default_expense_id_to_pay_commisions",
        "margin_price_formula",
        "users_can_view_price_groups",
        "users_can_view_warehouse_quantitys",
        "product_variant_language",
        "product_variants_language",
        "send_electronic_invoice_to",
        "copy_mail_to_sender",
        "days_before_current_date",
        "days_after_current_date",
        "add_individual_attachments",
        "product_crud_validate_cost",
        "alert_zero_cost_sale",
        "customer_branch_language",
        "customer_branches_language",
        "barcode_reader_exact_search",
        "which_cost_margin_validation",
        "max_minutes_random_pin_code",
        "cron_job_db_backup",
        "cron_job_images_backup",
        "cron_job_ebilling_backup",
        "cron_job_send_mail",
        "fe_work_environment",
        "fe_technical_annex_version",
        "management_consecutive_suppliers",
        "url_web",
        "profitability_margin_validation",
        "prorate_shipping_cost",
        "session_expiration_time",
        "product_order",
        "keep_seller_from_user",
        "invoice_values_greater_than_zero",
        "except_category_taxes",
        "category_tax_exception_start_date",
        "category_tax_exception_end_date",
        "category_tax_exception_tax_rate_id",
        "customer_territorial_decree_tax_rate_id",
        "ipoconsumo",
        "default_return_payment_method",
        "manual_payment_reference",
        "self_withholding_percentage",
        "item_discount_apply_to",
        "gift_card_language",
        "automatic_update",
        "wappsi_rest_url",
        "dropbox_key",
        "dropbox_secret",
        "dropbox_token",
        "detail_due_sales",
        "detail_partial_sales",
        "detail_paid_sales",
        "detail_products_expirated",
        "detail_products_promo_expirated",
        "detail_sales_per_biller",
        "detail_pos_registers",
        "detail_zeta_report",
        "great_contributor",
        "annual_closure",
        "product_variant_per_serial",
        "product_search_show_quantity",
        "suspended_sales_to_retail",
        "payments_methods_retcom",
        "product_default_exempt_tax_rate",
        "ciiu_code",
        "production_order_one_reference_limit",
        "system_start_date",
        "set_product_variant_suffix",
        "disable_product_price_under_cost",
        "wms_picking_filter_biller",
        "accounting_year_suffix",
        "enable_customer_tax_exemption",
        "block_movements_from_another_year",
        "product_transformation_validate_quantity",
        "rete_other_language",
        "last_update",
        "product_preferences_management",
        "management_order_sale_delivery_time",
        "delivery_day_max_orders"
    ];
    
}
