<?php
namespace App\Validation;

// use App\Validation\GeneralRulesMessasges;
/**
 * This class contains statics methods to access multiple rules and valitations
 * used un SmaPurchases controller
 */
class SmaDeliveryTimeValidations extends GeneralValidations
{
    static public function avaiableDeliveryTimeRules(){
        return [
            'date' => 'string|required',
            // 'location' => 'required',
        ];
    }
    static public function avaiableDeliveryTimeMessages(){
        return [
            'date' => [
                'string' => 'Tipo de dato no valido',
                'required' => 'Debe suministrar una fecha',
            ],
            // 'location' => [
            //     'required' => 'Debe suministrar una locasión',
            //     // 'string' => 'Tipo de dato no valido',
            // ],
        ];
    }

    static public function checkConsecutiveNoRules(){
        return [
            'supplier_id' => 'required|numeric',
            'consecutive_supplier' => 'required|string',
        ];
    }
    static public function checkConsecutiveNoMessages(){
        return [
            'supplier_id' => [
                'required' => 'Tipo de dato no valido',
            ],
            'consecutive_supplier' => [
                'required' => 'Tipo de dato no valido',
            ],
        ];
    }

    static public function newRules(){
        return [
            // for some reason it doesnt detect it
            'purchase' => 'required',
            'purchase_items' => 'required',
        ];
    }
    static public function newMessages(){
        return [
            'purchase' => [
                'required' => 'Es necesaria la información de la cotización para su creación',
            ],
            'purchase_items' => [
                'required' => 'Es necesaria la información de los productos de la cotización para su creación',
            ],

        ];
    }
}
