<?php
namespace App\Validation;

// use App\Validation\GeneralRulesMessasges;
/**
 * This class contains statics methods to access multiple rules and valitations
 * used un SmaPurchases controller
 */
class SmaPurchasesValidations extends GeneralValidations
{
    /**
     * Validation rules for pruchase reference validation.
     *
     * 
     *
     * @return array 
    */
    static public function checkReferenceNoRules(){
        return [
            'supplier_id' => 'required|numeric',
            'reference_no' => 'required|string',
        ];
    }
    /**
     * Validation messahes for purchase reference validation.
     *
     * 
     *
     * @return array 
    */
    static public function checkReferenceNoMessages(){
        return [
            'supplier_id' => [
                'required' => 'Tipo de dato no valido',
            ],
            'reference_no' => [
                'required' => 'Tipo de dato no valido',
            ],
        ];
    }
    /**
     * Validation rules for purchase consecutive validation.
     *
     * 
     *
     * @return  array
    */
    static public function checkConsecutiveNoRules(){
        return [
            'supplier_id' => 'required|numeric',
            'consecutive_supplier' => 'required|string',
        ];
    }

    /**
     * Validation messages for purchase consecutive_supplier validaton.
     *
     * 
     *
     * @return array
    */
    static public function checkConsecutiveNoMessages(){
        return [
            'supplier_id' => [
                'required' => 'Tipo de dato no valido',
            ],
            'consecutive_supplier' => [
                'required' => 'Tipo de dato no valido',
            ],
        ];
    }
    /**
     * Return purchase creation validation rules.
     * 
     * @todo Create specific validations rules for purchase and purchase_items data.
     *
     * @return array
     */
    static public function newRules(){
        return [
            // for some reason it doesnt detect it
            'purchase' => 'required',
            'purchase_items' => 'required',
        ];
    }

    /**
     * Return purchase creation validation messages.
     * 
     * @todo Create specific validations messages for purchase and purchase_items data.
     *
     * @return array
     */
    static public function newMessages(){
        return [
            'purchase' => [
                'required' => 'Es necesaria la información de la cotización para su creación',
            ],
            'purchase_items' => [
                'required' => 'Es necesaria la información de los productos de la cotización para su creación',
            ],

        ];
    }
}
