<?php namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();
$routes->setAutoRoute(true);

/**
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Home::index');


/**
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */

$routes->post("auth/login", "SmaUsers::login");


// auth routes
$routes->group("auth", ['filter'=>'auth' ],function ($routes) {

    $routes->get("refreshToken", "SmaUsers::refreshToken");
    $routes->get("logout", "SmaUsers::logout");
    $routes->post("verifyUserName", "SmaUsers::verifyUserName");
    $routes->post("verifyUserExist", "SmaUsers::verifyUserExist");
    
    // $routes->get("profile", "SmaUsers::details");
});

$routes->group("register", ['filter'=>'auth' ],function ($routes) {

    $routes->post("open", "SmaPosRegister::open");
    $routes->post("close", "SmaPosRegister::close");
    $routes->post("newMovement", "SmaPosRegisterMovements::newMovement");
    
});


$routes->group("test", function ($routes) {

    $routes->post("database-switch", "SmaCountries::dbSwitch");
    
});

$routes->group("appSettings",['filter'=>'auth' ], function ($routes) {
    $routes->get("feTech", "AppSettings::getFEProviderData");
});

/**
 * Routes to sync data from cloud db
 */
$routes->group("sync", ['filter'=>'auth' ],function ($routes) {

    $routes->post("products", "SmaProducts::sync");

    $routes->post("addresses", "SmaAddresses::sync");
    $routes->post("billerData", "SmaBillerData::sync");
    $routes->post("companies", "SmaCompanies::sync");
    $routes->post("suppliers", "SmaCompanies::syncSuppliers");
    $routes->post("settings", "SmaSettings::sync");
    $routes->post("customerGroups", "SmaCustomerGroups::sync");
    $routes->post("priceGroups", "SmaPriceGroups::sync");
    $routes->post("productPhotos", "SmaProductPhotos::sync");
    $routes->post("productPrices", "SmaProductPrices::sync");
    $routes->post("productPreferences", "SmaProductPreferences::sync");
    $routes->post("productVariants", "SmaProductVariants::sync");
    $routes->post("brands", "SmaBrands::sync");
    $routes->post("warehousesProducts", "SmaWarehousesProducts::sync");
    $routes->post("paymentMethods", "SmaPaymentMethods::sync");
    $routes->post("taxRates", "SmaTaxRates::sync");
    $routes->post("posSettings", "SmaPosSettings::sync");
    $routes->post("documentypes", "SmaDocumentypes::sync");
    $routes->post("countries", "SmaCountries::sync");
    $routes->post("states", "SmaStates::sync");
    $routes->post("cities", "SmaCities::sync");
    $routes->post("productCategories", "SmaCategories::sync");
    $routes->post("companyGroups", "SmaGroups::sync");
    // $routes->post("productUnits", "SmaUnits::sync");
    $routes->post("warehouses", "SmaWarehouses::sync");
    $routes->post("units", "SmaUnits::sync");
    $routes->post("unitPrices", "SmaUnitPrices::sync");
    $routes->post("documentsTypes", "SmaDocumentsTypes::sync");
    $routes->post("billerDocumentsTypes", "SmaBillerDocumentsTypes::sync");
    $routes->post("orders", "SmaOrderSales::sync");
    $routes->post("purchases", "SmaPurchases::sync");
    $routes->post("quotes", "SmaQuotes::sync");
    $routes->post("sales", "SmaSales::sync");
    $routes->get("allSales", "SmaSales::syncAllSales");
});

$routes->group("sales", [],function ($routes) {
    $routes->post("new", "Sales::new");
    
});


$routes->group("orders", ['filter'=>'auth'],function ($routes) {

    $routes->post("new", "SmaOrderSales::new");
    $routes->post("cancel", "SmaOrderSales::cancellPendingOrder");
    $routes->post("findOrders", "SmaOrderSales::findOrders");
    
});
$routes->group("quotes", ['filter'=>'auth' ],function ($routes) {

    $routes->post("new", "SmaQuotes::new");
    
});
$routes->group("error", ['filter'=>'auth' ],function ($routes) {

    $routes->post("reportError", "Errors::logError");
    
});
$routes->group("addresses", ['filter'=>'auth' ],function ($routes) {
    $routes->post("newAddress", "SmaAddresses::addAddress");
    $routes->post("addAddressZoneSZone", "SmaAddresses::addAddressZoneSZone");

});
$routes->group("deliveryTime", ['filter'=>'auth' ],function ($routes) {
    $routes->post("getDeliveryTimes", "SmaDeliveryTime::avaiableDeliveryTime");
});
$routes->group("purchases", ['filter'=>'auth' ],function ($routes) {
    $routes->post("new", "SmaPurchases::new");
    $routes->post("checkReferenceNo", "SmaPurchases::checkReferenceNo");
    $routes->post("checkConsecutiveNo", "SmaPurchases::checkConsecutiveNo");
});
$routes->group("wishlist", ['filter'=>'auth' ],function ($routes) {

    $routes->get("all", "SmaWishlist::getAll");
    $routes->post("userFavorites", "SmaWishlist::getUserFavorites");
    $routes->post("deleteCompanyFavorites", "SmaWishlist::deleteCompanyFavorites");
    $routes->post("addCompanyFavorites", "SmaWishlist::addCompanyFavorites");
    $routes->post("companyFavorites", "SmaWishlist::getCompanyFavorites");
    
});
$routes->group("companies", ['filter'=>'auth' ],function ($routes) {

    $routes->post("newCustomer", "SmaCompanies::addCustomer");
    // to support old versions 
    $routes->post("newCompany", "SmaCompanies::addCustomer");
    $routes->post("newCompany2", "SmaCompanies::addCompany");

    $routes->post("newSupplier", "SmaCompanies::addSupplier");
    
});

$routes->group("locations", [],function ($routes) {

    $routes->post("cityZones", "SmaZones::getCityZones");
    $routes->post("zoneSubzones", "SmaSubzones::getZoneSubzones");
    $routes->post("locationData", "SmaZones::getLocationSZoneData");
    // to support old versions 
    
});
$routes->group("utils", function ($routes) {

    $routes->post("pngToJpg", "Utils::pngToJpg");
    $routes->post("jpgWhiteToPng", "Utils::jpgWhiteToPng");
    $routes->post("jpgBlackToPng", "Utils::jpgBlackToPng");
    
});

$routes->group("test", [],function ($routes) {

    // $routes->get("testCountOrder", "SmaOrderSales::test");
    $routes->post("cancelOrder", "SmaOrderSales::cancellPendingOrder");
    
});

if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
