<?php

/**
 * settings table's controller.
 *
 * Used to perform operations on settings table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
 */

namespace App\Controllers;


use App\Models\AppSettingsModel;
use App\Models\TechnologyProvidersModel;
use CodeIgniter\RESTful\ResourceController;

class AppSettings extends ResourceController
{

    /**
     * Get tech provider data
     *
     * Given a token from request, ask client db for feProvider id and returns
     * its data.
     *      
     *
     * @return  array
     */
    public function getFEProviderData()
    {
        // return $this->respondCreated(['error'=>false, 'data'=>['asd'=>123]]);
        try {
            $appSettings = new AppSettingsModel();

            $techProviders = new TechnologyProvidersModel();

            $feProvider = SmaSettings::getSettingsColumnData('fe_technology_provider', $this->dbGroupFromRequest());


            $appSettingsData = $appSettings->select(['print_footer'])->first();
            $techProviderData = $techProviders->where(['id' => $feProvider])->first();

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'data' => [
                    'technology_provider' => $techProviderData,
                    'print_footer' => $appSettingsData['print_footer'],
                ],
            ];
        } catch (\Throwable $th) {
            $response = [
                'status' => 501,
                'error' => true,
                'message' => 'Error on getting data',
                'data' => $th,
            ];
        }

        return $this->respondCreated($response);
    }

    /**
     * Get tech provider data
     *
     * Given a token from request, ask client db for feProvider id and returns
     * its data.
     *      
     *
     * @return  array
     */
    public static function getStaticFooterPrint($dbGroup)
    {

        $feProvider = SmaSettings::getSettingsColumnData('fe_technology_provider', $dbGroup);
        $appSettings = new AppSettingsModel();

        $techProviders = new TechnologyProvidersModel();


        $techProviderData = $techProviders->where(['id' => $feProvider])->first();

        $appSettingsData = $appSettings->select('print_footer')->first();;


        return [
            'technology_provider' => $techProviderData,
            'print_footer' => $appSettingsData['print_footer'],
        ];
    }
}
