<?php
/**
 * countries table's controller.
 *
 * Used to perform operations on countries table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;



use App\Models\SmaCountriesModel;
use CodeIgniter\RESTful\ResourceController;

class SmaCountries extends ResourceController
{
    /**
     * Get updated countries table's rows.
     *
     * 
     * Based on last_sync value (from request), return updated rows from countries.
     *
     * Request should contain last_sync value (date) to get updated rows based on
     * that date.
     *
     * If request contains first_time = true, it returns all data in countries table.
     *
     * @deprecated Never used
     * 
     * @return  
    */
    public function sync(){

        $this->setModel(new SmaCountriesModel($this->dbGroupFromRequest()));

        $rules = [
            'last_sync' => 'valid_date',
            // 'first_time'=> ''
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],
            // 'first_time' => [
            //     'required' => '',
            // ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $products_list = [];

            if($this->request->getVar('first_time')==true){

   
                $products_list = $this->getAllRows([]);



            }else if($this->request->getVar('first_time')==false){
                $products_list = $this->getUpdatedRows([]);
            }else{
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'EL campo "first_time" no es valido',
                    'data' => []
                ];
    
                return $this->respondCreated($response);
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time'=> $this->getServerDateTime(),
                'data' => $products_list
            ];

            return $this->respondCreated($response);

        }

    }

    public function dbSwitch(){
        $this->setModel(new SmaCountriesModel('default'));

        $rules = [
            'last_sync' => 'valid_date',
            'company'=>'string'
            // 'first_time'=> ''
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $products_list = [];

   
            $products_list = $this->getAllRows([]);




            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time'=> $this->getServerDateTime(),
                'data' => $products_list
            ];

            return $this->respondCreated($response);

        }

    }

}