<?php

/**
 * product_preferences table's controller.
 *
 * Used to perform operations on product_preferences table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
 */

namespace App\Controllers;



use App\Models\SmaProductPreferencesModel;
use CodeIgniter\RESTful\ResourceController;

class SmaProductPreferences extends ResourceController
{

    /**
     * Get updated product_preferences table's rows.
     *
     * 
     * Based on last_sync value (from request), return updated rows from product_preferences.
     *
     * Request should contain last_sync value (date) to get updated rows based on
     * that date.
     *
     * If request contains first_time = true, it returns all data in table.
     *
     *
     * @return HttpResponse 
     */
    public function sync()
    {

        $this->setModel(new SmaProductPreferencesModel($this->dbGroupFromRequest()));

        $rules = [
            'last_sync' => 'valid_date'
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],

        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date' => $this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
        } else {
            // validate
            $prod_pref = [];
            $pref = [];
            $pref_cat = [];

            if ($this->request->getVar('first_time') == true) {


                $prod_pref = $this->getAllRows(['id' => 'id_cloud']);
                $pref = SmaPreferences::getAllPreferencesInfo($this->dbGroupFromRequest());
                $pref_cat = SmaPreferencesCategories::getAllPreferencesCategoriesInfo($this->dbGroupFromRequest());
            } else if ($this->request->getVar('first_time') == false) {
                $last_sync = $this->request->getVar('last_sync');
                $join_table = 'sma_products';
                $join_condition = "sma_products.last_update > '$last_sync'";
                $join_type = 'inner';
                $prod_pref = $this->getJoinRows(
                    ['id' => 'id_cloud'],
                    null,
                    null,
                    $join_table,
                    $join_condition,
                    $join_type
                );

                $pref = SmaPreferences::getUpdatedPrefs($last_sync, $this->dbGroupFromRequest(),);
                $pref_cat = SmaPreferencesCategories::getUpdatedPrefsCats($last_sync, $this->dbGroupFromRequest(),);
            } else {
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'EL campo "first_time" no es valido',
                    'data' => []
                ];

                return $this->respondCreated($response);
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time' => $this->getServerDateTime(),
                'data' => [
                    'sma_product_preferences' => $prod_pref,
                    'sma_preferences' => $pref,
                    'sma_preferences_categories' => $pref_cat
                ]
            ];

            return $this->respondCreated($response);
        }
    }
}
