<?php
/**
 * settings table's controller.
 *
 * Used to perform operations on settings table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;



use App\Models\SmaSettingsModel;
use CodeIgniter\RESTful\ResourceController;

class SmaSettings extends ResourceController
{
    
    /**
     * Get changes on settings table.
     *
     * 
     * Based on last_sync value (from request), return changes from settings.
     *
     * Request should contain last_sync value (date) to changes based on
     * that date.
     *
     * If request contains first_time = true, it returns all data in table.
     *
     *
     * @return  HttpResponse
    */
    public function sync(){

        $this->setModel(new SmaSettingsModel($this->dbGroupFromRequest()));

        $rules = [
            'last_sync' => 'valid_date',
            // 'first_time'=> ''
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],
            // 'first_time' => [
            //     'required' => '',
            // ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $products_list = [];

            if($this->request->getVar('first_time')==true){

   
                $products_list = $this->getAllRows([]);



            }else if($this->request->getVar('first_time')==false){
                $products_list = $this->getUpdatedRows([]);
            }else{
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'EL campo "first_time" no es valido',
                    'data' => []
                ];
    
                return $this->respondCreated($response);
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time'=> $this->getServerDateTime(),
                'data' => $products_list
            ];

            return $this->respondCreated($response);

        }

    }


    /**
     * Returns selected data in sma_settings, $column field is a string who 
     * determines wich column to return
     *
     * @param string $column
     * @return string|int|null
     */
    static public function getSettingsColumnData($column,$dbGroup)
    {
        $sModel = new SmaSettingsModel($dbGroup);
        $data = $sModel->select($column)
            ->first();
        return $data[$column];
    }
    /**
     * Returns selected data in sma_settings, $column field is a string who 
     * determines wich column to return
     *
     * @param string $columns
     * @return string|int|null
     */
    static public function getSettingsColumnsData($columns,$dbGroup)
    {
        $sModel = new SmaSettingsModel($dbGroup);
        $data = $sModel->select($columns)
            ->first();
        return $data;
    }

}