<?php

/**
 * zones table's controller.
 *
 * Used to perform operations on zones table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
 */

namespace App\Controllers;



use App\Models\SmaZonesModel;
use CodeIgniter\RESTful\ResourceController;

class SmaZones extends ResourceController
{

    /**
     * Get city zones.
     *
     * Given a city_code from request, return all zones for the city_code.
     *
     * @return HttpResponse 
     */
    public function getCityZones()
    {

        $rules = [
            'city_code' => 'required'
        ];
        $message = [
            'city_code' => [
                'required' => 'Codigo de ciudad requerido',
            ],

        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails


            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
            ];

            return $this->respondCreated($response);
        } else {
            // validate
            $this->setModel(new SmaZonesModel($this->dbGroupFromRequest()));

            $data = $this->model->getAllRows(["codigo_ciudad" => $this->request->getVar("city_code")]);
            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                "data" => $data
            ];

            return $this->respondCreated($response);
        }
    }


    /**
     * Get zone info.
     *
     * Given a zone_id, return first result with the same zone_id.
     * 
     * 
     * @param int  $zone_id   
     *
     *
     * @return  array
     */
    static public function getZoneInfo($zone_id, $dbGroup)
    {
        $model = new SmaZonesModel($dbGroup);

        return $model->where("id", $zone_id)->first();
    }


    /**
     * Get zone and subzone info.
     *
     * Given zone_id and subzone_id, returns its info. (from request info)
     *
     * @return  HttpResponse
     */
    /**
     * Get city zones.
     *
     * Given a city_code from request, return all zones for the city_code.
     *
     * @return HttpResponse 
     */
    public function getLocationSZoneData()
    {



        $rules = [
            'zone_id' => 'required',
            // 'subzone_id' => 'required'

        ];
        $message = [
            'zone_id' => [
                'required' => 'Id de zona requerido.',
            ],

        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails


            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
            ];

            return $this->respondCreated($response);
        } else {
            // validate
            $zone_info = $this->getZoneInfo($this->request->getVar("zone_id"), $this->dbGroupFromRequest(),);
            $subzone_info = null;
            if (!empty($this->request->getVar("subzone_id") ?? "")) {
                $subzone_info = SmaSubzones::getSubzoneInfo($this->request->getVar("subzone_id"),$this->dbGroupFromRequest());
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                "data" => [
                    "zone_data" => $zone_info,
                    "subzone_data" => $subzone_info
                ]
            ];

            return $this->respondCreated($response);
        }
    }
}
