<?php

// use App\Models\SmaSmaUsersModel

// if (!defined('BASEPATH'))
//         exit('No direct script access allowed');

use App\Controllers\SmaSubzones;
use App\Controllers\SmaUnits;
use App\Controllers\SmaZones;
use App\Models\SmaAddressesModel;
use App\Models\SmaCompaniesModel;

/**
 * Returns html email header
 * @param string $name
 * @param string $image_url
 * @param string $url
 *
 * @return string
 */
function emailHeader($url, $image_url, $name)
{
    $header = '<div id=":q8" class="a3s aiL ">
        <div class="adM">
        </div>
        <div style="background-color:#f5f5f5">
            <div class="adM">
            </div>
            <div style="padding:10px 0">
                <div class="adM">
                </div>
                <table style="width:600;max-width:600px;" align="center">
                    <tbody>
                        <tr>
                            <td>
                                <table role="presentation" style="width:100%">
                                    <tbody>
                                        <tr>
                                            <td style="vertical-align:top;padding:23px 23px" align="left">
                                                <a href="' . $url . '">
                                                    <img style="height:50px;vertical-align:middle"
                                                        src="' . $image_url . '"
                                                        title="' . $name . '" class="CToWUd">
                                                </a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div
                                    style="height:0px;font-size:0px;max-height:0px;min-height:0px;line-height:0px;width:100%;color:#fff;display:none">
                                </div>


                            </td>
                        </tr>
                   
                ';
    return $header;
}

/**
 * Returns html email head with head and some text
 *  @param string $greeting
 *  @param string $text1
 *  @param string $text2
 * @return string
 */
function emailHead($greeting, $text1)
{
    $head = '
    <table
                    style="border:1px solid #dedede;border-spacing:0px;width:600;max-width:600px;border:1px solid #dedede;border-spacing:0px;width:600;max-width:600px;background-color:#ffffff"
                    align="center">
    <tbody>
    <tr>
        <td
            style="vertical-align:top; text-overflow: ellipsis;padding:30px 25px;border-top:1px solid #e0e0e0;font-weight:400;font-size:14px;line-height:22px;color:#455a64">
            <div
                style="color:#263238;font-weight:700;font-size:20px;font-family:Google Sans,Roboto,sans-serif;line-height:20px;padding:0 0">
                ' . $greeting . ',</div>
            <p>' . $text1 . '</p>
        
        </td>
    </tr>';
        
    return $head;
}


/**
 * Returns order header with in a html table
 *  @param array $orderData
 * @return string
 */
function orderHeader($orderData){
    $companyModel = new SmaCompaniesModel();
    $addressesModel = new SmaAddressesModel();
    $customerInfo = $companyModel->find($orderData['customer_id']);
    $sellerInfo = $companyModel->find($orderData['seller_id']);
    $customerAdd = $addressesModel->find($orderData['address_id']);
    $zoneInfo = SmaZones::getZoneInfo($customerAdd["location"]??0);
    $subzoneInfo = SmaSubzones::getSubzoneInfo($customerAdd["subzone"]??0);

    $zonehtml = "";
    if(!empty($zoneInfo)){

        
        $zonehtml = '
        <tr>
            <td><strong>Zona</strong></td>

            <td>'.($zoneInfo['zone_name']??"")." / ".($subzoneInfo['subzone_name']??"").'</td>
        </tr>';
        
    }
    
    


    $orderHeader = '
    <h3 style="margin-bottom: 10px;;text-align:center;margin-top:30px;margin-bottom:30px; font-family:Google Sans,Roboto,sans-serif;font-size:16px;line-height:22px;color:#455a64"">'.$orderData['reference_no'].'</h3>
    <table
            style="table-layout: fixed; text-overflow: ellipsis;margin-left: 50px;margin-right: 50px;padding:30px 10px 10px 10px;margin-top: 10px ; width: 500px;max-width: 500px;color:#263238;font-weight:400;font-size:15px;font-family:Google Sans,Roboto,sans-serif;line-height:20px;padding:0 0">

            <col width="120px" />
            <col width="380px" />

        <tr>
            <td><strong>Cliente</strong></td>

            <td>'.($orderData['customer']??"").'</td>
        </tr>
        <tr>
            <td><strong>NIT/CC</strong></td>

            <td>'.($customerInfo['vat_no']??"").'</td>
        </tr>
        <tr>
            <td><strong>Dirección</strong></td>

            <td>'.($customerAdd['direccion']??"").'</td>
        </tr>
        <tr>
            <td><strong>Email</strong></td>


            <td>'.($customerAdd['email']??"").'</td>
        </tr>
        <tr>
            <td><strong>Vendedor</strong></td>


            <td>'.($sellerInfo['name']??"").'</td>
        </tr>'.
        $zonehtml
        .'
    </table>';
    
    return $orderHeader;
}

/**
 * Returns html email body with a body table
 *  @param array $data
 *  @param array $data_keys
 * @return string
 */
function emailOrderBodyWUnits($orderData,$orderItemsData)
{
    // date('Y')
    $productsTable = '';
    for ($i=0; $i < count($orderItemsData); $i++) { 
        $qtty =strval($orderItemsData[$i]['unit_quantity']);
        $uCode =strval($orderItemsData[$i]['product_unit_code']);
        $name =strval($orderItemsData[$i]['product_name']);
        $priceVal = $orderItemsData[$i]['subtotal'];
        $price = '$'.number_format($priceVal,2);
        $productsTable.=' 
            <tr>
                <td style="text-overflow: ellipsis">'.$qtty.'</td>
                <td style="text-overflow: ellipsis">'.$uCode.'</td>
                <td style="text-overflow: ellipsis">'.$name.'</td>
                <td align="right"  style="text-overflow: ellipsis">'.$price.'</td>
            </tr>';
        
        $pUnit = SmaUnits::getProductUnitWithBaseUnitData($orderItemsData[$i]['product_unit_id']);
        if(isset($pUnit)){
            $bUnitVal = '$'.number_format($priceVal/($pUnit['operation_value']??1),2);
            $productsTable.=' 
            <tr>
                <td></td>
                <td></td>
                <td>'.$pUnit['base_unit_code'].' x '.$bUnitVal.'</td>
                <td></td>
            </tr>';
        }
    }

    $emptyTableLine = '
    <tr>
            <td> </td>
            <td> </td>
            <td> </td>
        </tr>
    ';
    $totalValues = '
    <tr>
        <td> </td>
        <td align="right">SubTotal</td>
        <td align="right" style="text-overflow: ellipsis"><strong>'.'$'.number_format($orderData['total']).'</strong></td>
    </tr>
    <tr>
        <td> </td>
        <td align="right">Descuento</td>

        <td align="right" style="text-overflow: ellipsis"><strong>'.'$'.number_format($orderData['total_discount']).'</strong></td>
    </tr>
    <tr>
        <td> </td>
        <td align="right">IVA</td>

        <td align="right" style="text-overflow: ellipsis"><strong>'.'$'.number_format($orderData['total_tax']).'</strong></td>
    </tr>
    <tr>
        <td> </td>
        <td align="right">Total</td>

        <td align="right" style="text-overflow: ellipsis"><strong>'.'$'.number_format($orderData['grand_total']).'</strong></td>
    </tr>
    
    ';

    $note = "";

    if(!empty($orderData['note']??"")){
        $note = '
        <tr>
            <td
            style="vertical-align:top;padding:30px 25px;border-top:1px solid #e0e0e0;font-weight:600;font-size:14px;line-height:22px;color:#1A1D1F">
            <p>Nota </p>
            <h3>' . $orderData['note'] . '</h3>
        
            </td>
        </tr>

        ';
    }

    

    $note2='';
    if(!empty($orderData['staff_note']??"")){
        $note2 = '
        <tr>
            <td
            style="vertical-align:top;padding:30px 25px;border-top:1px solid #e0e0e0;font-weight:600;font-size:14px;line-height:22px;color:#1A1D1F">
            <p>Nota interna</p>
            <h3>' . $orderData['staff_note'] . '</h3>
        
            </td>
        </tr>

        ';
    }
    
    $body = '
    <table  style="margin-left: 50px;margin-right: 50px;margin-top: 10px;border-top: 1px #808d8e solid;border-bottom: 1px #808d8e solid;padding: 5px 5px 5px 5px;table-layout: fixed; width: 500px;max-width: 500px;color:#263238;font-weight:400;font-size:15px;font-family:Google Sans,Roboto,sans-serif;line-height:20px;padding:0 0">
        <col width="40px" />
        <col width="75px" />
        <col width="285px"/>
        <col width="100px"/>

        <thead>
            <th align="left">Cant</th>
            <th align="left">UM</th>
            <th align="left">Producto</th>
            <th align="right">Precio</th>
        </thead>
        '.$productsTable.'

    </table>';
    $body2 = '
    <table  style="margin-left: 50px;margin-right: 50px;margin-bottom: 30px;padding: 5px 5px 5px 5px;table-layout: fixed; width: 500px;max-width: 500px;color:#263238;font-weight:400;font-size:15px;font-family:Google Sans,Roboto,sans-serif;line-height:20px;padding:0 0">
        <col width="260px" />
        <col width="100px" />
        <col width="140px" />

        <thead>
            
        </thead>
        '.$emptyTableLine.'
        '.$totalValues.'
    </table>'.$note.$note2;
    
    return $body.$body2;
}

/**
 * Returns html email body with a body table

 * @return string
 */
function emailFooter(string $image_url, string $company_name, $footer_message)
{

    $footer = '
    <tr>
        <td
        style="vertical-align:top;padding:30px 25px;border-top:1px solid #e0e0e0;font-weight:400;font-size:14px;line-height:22px;color:#455a64">
        <p>Gracias por elegirnos</p>
        <h3><strong>' . $company_name . '</strong></h3>
    
        </td>
    </tr>
        
    <tr>
            <td
                style="vertical-align:top;background-color:#f4f4f6;color:#5A5F58;font-weight:400;font-size:12px;line-height:16px;padding:20px 25px;text-align:center">
                ' . $footer_message . '
            </td>
    </tr>
        <tr>
            <td style="text-align:center;vertical-align:top;background-color:#5A5F58;padding:24px 24px">
                <table style="width:100%;border:0;border-spacing:0px;border-collapse:separate;padding:0">
                    <tbody>
                        <tr>
                            <td valign="middle" align="left">
                                <img alt=""
                                    src="' . $image_url . '"
                                    title="Wappsi" style="display:block" class="CToWUd" width="120"
                                    height="30">
                            </td>

                            <td style="color:#d6dde1;font-weight:400;font-size:12px;line-height:14px;padding:0 0"
                                valign="middle" align="right">
                                <a href="https://www.wappsi.com.co/" style="text-decoration:none;color:#f4f4f6">
                                    © ' . date('Y') . ' Wappsi
                                    <br>
                                    Todos los derechos reservados
                                </a>
                            </td>
                        </tr>
                    </tbody>
                </table>
            
            </td>
        </tr>
    </tbody>
    </tbody>
    </table>
    </table>
    </div>
    </div>
    <div class="yj6qo"></div>
    <div class="adL">

    </div>
    </div>
    ';
    return $footer;
}
