<?php

namespace App\Models;

use CodeIgniter\Model;
use CodeIgniter\Database\ConnectionInterface;
use CodeIgniter\Validation\ValidationInterface;



class SmaAddressesModel extends Model
{
    public function __construct(String $DBGroup = 'default',ConnectionInterface $db = null, ValidationInterface $validation = null)
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_addresses';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [
        'company_id',
        'geo_location',
        'direccion',
        'sucursal',
        'city',
        'state',
        'country',
        'phone',
        'city_code',
        'customer_group_id',
        'customer_group_name',
        'price_group_name',
        'price_group_id',
        'email',
        'code',
        "subzone",
        "location"
    ];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];
    
    protected $allowedFieldsToApp       = [
        "id",
        "company_id",
        "direccion",
        "sucursal",
        "city",
        "postal_code",
        // this should be removed in future updates
        "geo_location",
        "latitude",
        "longitude",
        "state",
        "country",
        "phone",
        "updated_at",
        "city_code",
        "customer_address_seller_id_assigned",
        "customer_group_id",
        "customer_group_name",
        "price_group_id",
        "price_group_name",
        "seller_sale_comision",
        "seller_collection_comision",
        "code",
        "line1",
        "line2",
        "email",
        "vat_no",
        "location",
        "subzone",
        "last_update",
    ];


}
