<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaSalesModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_sales';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    protected $allowedFieldsToApp       = [
        "id",
        "date",
        "reference_no",
        "customer_id",
        "customer",
        "biller_id",
        "biller",
        "warehouse_id",
        "note",
        "staff_note",
        "total",
        "product_discount",
        "order_discount_id",
        "total_discount",
        "order_discount",
        "product_tax",
        "order_tax_id",
        "order_tax",
        "total_tax",
        "shipping",
        "grand_total",
        "sale_status",
        "payment_status",
        "payment_term",
        "due_date",
        "created_by",
        "updated_by",
        "updated_at",
        "total_items",
        "pos",
        "paid",
        "return_id",
        "surcharge",
        "attachment",
        "return_sale_ref",
        "sale_id",
        "return_sale_total",
        "rounding",
        "suspend_note",
        "api",
        "shop",
        "address_id",
        "seller_id",
        "reserve_id",
        "hash",
        "manual_payment",
        "cgst",
        "sgst",
        "igst",
        "payment_method",
        "pay_partner",
        "rete_fuente_percentage",
        "rete_fuente_total",
        "rete_fuente_account",
        "rete_fuente_base",
        "rete_iva_percentage",
        "rete_iva_total",
        "rete_iva_account",
        "rete_iva_base",
        "rete_ica_percentage",
        "rete_ica_total",
        "rete_ica_account",
        "rete_ica_base",
        "rete_other_percentage",
        "rete_other_total",
        "rete_other_account",
        "rete_other_base",
        "resolucion",
        "fe_correo_enviado",
        "fe_aceptado",
        "fe_recibido",
        "cufe",
        "codigo_qr",
        "fe_id_transaccion",
        "fe_mensaje",
        "fe_mensaje_soporte_tecnico",
        "fe_xml",
        "fe_debit_credit_note_concept_dian_code",
        "sale_currency",
        "sale_currency_trm",
        "cost_center_id",
        "document_type_id",
        "payment_method_fe",
        "payment_mean_fe",
        "tip_amount",
        "shipping_in_grand_total",
        "sale_origin",
        "sale_origin_reference_no",
        "rete_fuente_id",
        "rete_iva_id",
        "rete_ica_id",
        "rete_other_id",
        "sale_comm_perc",
        "collection_comm_perc",
        "sale_comm_amount",
        "sale_comm_payment_status",
        "debit_note_id",
        "reference_debit_note",
        "reference_invoice_id",
        "restobar_table_id",
        "consumption_sales",
        "self_withholding_amount",
        "self_withholding_percentage",
        "printed",
        "due_payment_method_id",
        "registration_date",
        "return_other_concepts",
        "rete_bomberil_percentage",
        "rete_bomberil_total",
        "rete_bomberil_account",
        "rete_bomberil_base",
        "rete_autoaviso_percentage",
        "rete_autoaviso_total",
        "rete_autoaviso_account",
        "rete_autoaviso_base",
        "rete_autoica_percentage",
        "rete_autoica_total",
        "rete_autoica_account",
        "rete_autoica_base",
        "rete_autoica_account_counterpart",
        "rete_autoaviso_account_counterpart",
        "rete_bomberil_account_counterpart",
        "rete_bomberil_id",
        "rete_autoaviso_id",
    ];

}
