<?php
namespace App\Validation;

// use App\Validation\GeneralRulesMessasges;

class SmaCompaniesValidation extends GeneralValidations{
    static public function getCreateCustomerRules(){
        return [
            'type_person' => 'numeric|required',
            'group_name' => 'string|required',
            'group_id' => 'numeric|required',
            'name' => 'string|required',
            'company' => 'string|required',
            'address' => 'string|required',
            'first_name' => 'string|required',
            // 'second_name'=>'',
            'first_lastname' => 'string|required',
            // 'second_lastname'=>'',
            'tipo_documento' => 'numeric|required',
            'document_code' => 'numeric|required',
            'vat_no' => 'numeric|required',
            // 'digito_verificacion'=>'',
            'city' => 'string|required',
            'city_code' => 'required',
            'state' => 'required',
            'country' => 'required',
            'phone' => 'numeric|required',
            'email' => 'required|string',
            'tipo_regimen' => 'numeric|required',
            'customer_group_name' => 'string|required',
            'price_group_name' => 'string|required',
            'customer_group_id' => 'numeric|required',
            'price_group_id' => 'numeric|required',
            'customer_only_for_pos' => 'numeric|required',
        ];
    }
    static public function getCreateCustomerMessages(){
        return [
            'group_name' => ['required' => 'El campo nombre de grupo es requerido.'],
            'group_id' => ['required' => 'El campo id de grupo es requerido.'],
            'type_person' => ['required' => 'El campo tipo de persona es requerido.'],
            'first_name' => ['required' => 'El campo primer nombre es requerido.'],
            'first_lastname' => ['required' => 'El campo primer apellido es requerido.'],
            'tipo_documento' => ['required' => 'El campo tipo de documento es requerido.'],
            'name' => ['required' => 'El campo nombre es requerido.'],
            'company' => ['required' => 'El campo compañia es requerido.'],
            // 'document_code' => ['required' => '.',],
            // 'vat_no' => ['required' => '.',],
            // 'digito_verificacion' => ['required' => '.',],
            // 'address' => ['required' => '.',],
            'city' => ['required' => 'El campo ciudad es requerido.'],
            'city_code' => ['required' => 'El campo codigo de ciudad es requerido.'],
            'state' => ['required' => 'El campo departamento es requerido.'],
            'country' => ['required' => 'El campo pais es requerido.'],
            // 'phone' => ['required' => '.',],
            // 'email' => ['required' => '.',],
            'customer_group_name' => ['required' => 'El campo nombre de grupo de clientes.'],
            'price_group_name' => ['required' => 'El campo nombre de grupo de precios.'],
            'customer_group_id' => ['required' => 'El campo id de grupo de clientes es requerido.'],
            'price_group_id' => ['required' => 'El campo id de grupo de precios es requerido.'],
            'customer_only_for_pos' => ['required' => 'El campo cliente para pos es requerido.'],

        ];
    }
    static public function getCreateProviderRules(){
        return [
            'type_person' => 'numeric|required',
            'group_name' => 'string|required',
            'group_id' => 'numeric|required',
            'name' => 'string|required',
            'company' => 'string|required',
            'address' => 'string|required',
            'first_name' => 'string|required',
            // 'second_name'=>'',
            'first_lastname' => 'string|required',
            // 'second_lastname'=>'',
            'tipo_documento' => 'numeric|required',
            'document_code' => 'numeric|required',
            'vat_no' => 'numeric|required',
            // 'digito_verificacion'=>'',
            'city' => 'string|required',
            'city_code' => 'required',
            'state' => 'required',
            'country' => 'required',
            'phone' => 'numeric|required',
            'email' => 'required|string',
            'tipo_regimen' => 'numeric|required',
            'supplier_type' => 'numeric|required',
            'customer_payment_type' => 'numeric|required',
            // 'customer_group_name' => 'string|required',
            // 'price_group_name' => 'string|required',
            // 'customer_group_id' => 'numeric|required',
            // 'price_group_id' => 'numeric|required',
            // 'customer_only_for_pos' => 'numeric|required',
        ];
    }
    static public function getCreateProviderMessages(){
        return [
            'group_name' => ['required' => 'El campo nombre de grupo es requerido.'],
            'group_id' => ['required' => 'El campo id de grupo es requerido.'],
            'type_person' => ['required' => 'El campo tipo de persona es requerido.'],
            'first_name' => ['required' => 'El campo primer nombre es requerido.'],
            'first_lastname' => ['required' => 'El campo primer apellido es requerido.'],
            'tipo_documento' => ['required' => 'El campo tipo de documento es requerido.'],
            'name' => ['required' => 'El campo nombre es requerido.'],
            'company' => ['required' => 'El campo compañia es requerido.'],
            // 'document_code' => ['required' => '.',],
            // 'vat_no' => ['required' => '.',],
            // 'digito_verificacion' => ['required' => '.',],
            // 'address' => ['required' => '.',],
            'city' => ['required' => 'El campo ciudad es requerido.'],
            'city_code' => ['required' => 'El campo codigo de ciudad es requerido.'],
            'state' => ['required' => 'El campo departamento es requerido.'],
            'country' => ['required' => 'El campo pais es requerido.'],
            'suplier_type' => ['required' => 'El campo tipo de proveedor es necesario'],
            'customer_payment_type' => ['required' => 'El campo tipo de pago del proveedor es necesario'],
            // 'phone' => ['required' => '.',],
            // 'email' => ['required' => '.',],

            // 'customer_group_name' => ['required' => 'El campo nombre de grupo de clientes.'],
            // 'price_group_name' => ['required' => 'El campo nombre de grupo de precios.'],
            // 'customer_group_id' => ['required' => 'El campo id de grupo de clientes es requerido.'],
            // 'price_group_id' => ['required' => 'El campo id de grupo de precios es requerido.'],
            // 'customer_only_for_pos' => ['required' => 'El campo cliente para pos es requerido.'],

        ];
    }

}