<?php
/**
 * categories table's controller
 *
 * Used to perform operations on categories table
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/

namespace App\Controllers;



use App\Models\SmaCategoriesModel;
use CodeIgniter\RESTful\ResourceController;

class SmaCategories extends ResourceController
{
    /**
     * Get updated rows from categories
     *
     * 
     * Based on last_sync value (from request), return updated rows from categories.
     *
     * Request should contain last_sync value (date) to get updated rows based on
     * that date.
     *
     * If request contains first_time = true, it returns all data in cities table.
     *
     *
     * @return  HttpResponse
    */
    public function sync(){

        $this->setModel(new SmaCategoriesModel($this->dbGroupFromRequest()));

        $rules = [
            'last_sync' => 'valid_date'
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $list = [];

            if($this->request->getVar('first_time')==true){

   
                $list = $this->getAllRows(['id'=>'id_cloud']);



            }else if($this->request->getVar('first_time')==false){
                $list = $this->getUpdatedRows(['id'=>'id_cloud']);
            }else{
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'EL campo "first_time" no es valido',
                    'data' => []
                ];
    
                return $this->respondCreated($response);
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time'=> $this->getServerDateTime(),
                'data' => $list
            ];

            return $this->respondCreated($response);

        }

    }

}