<?php
/**
 * Currencies table's controller.
 *
 * Used to perform operations on currencies table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;

use App\Models\SmaCurrenciesModel;

class SmaCurrencies extends BaseController
{

     /**
     * Returns default currency for system
     * 
     * @param int $dbGroup
     *
     * @return object|null
     */
    static public function getDefaultCurrency(String $dbGroup)
    {
        $model = new SmaCurrenciesModel($dbGroup);
        $res = $model->select($model->getColumnsString())
            ->select('*')
            ->first();
        // print_r($res);
        return $res;
    }

}