<?php
/**
 * quote_items table's controller.
 *
 * Used to perform operations on quote_items table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;

use App\Models\SmaQuoteItemsModel;
use CodeIgniter\RESTful\ResourceController;


class SmaQuoteItems extends ResourceController
{
    /**
     * Insert quote items inside quote_items, $items param shoul be an array of arrays, where keys are
     * table names for each value
     *
     * @param array $items
     * @param integer $quoteSaleId
     * 
     * @return int|null
     */
    static public function insertQuoteItems($items,$quoteSaleId,$dbGroup){
        $quoteItemsModel = new SmaQuoteItemsModel($dbGroup);

        // save quote id inside all quote items
        for ($i=0; $i < count($items); $i++) { 
            $items[$i]['quote_id'] = $quoteSaleId;
        }
        $result = $quoteItemsModel->insertBatch($items);

        return $result;
    } 
    /**
     * Given an quote id, returns it's items
     *
     * @param integer $quoteId
     * @return array|null
     */
    static public function getQuouteItems($quoteId,$dbGroup){
        $quoteItemsModel = new SmaQuoteItemsModel($dbGroup);
        // $items = $quoteItemsModel->select('*')->where(['quote_id'=>$quoteId])->findAll();
        $items = $quoteItemsModel->getSelectedRows(['quote_id'=>$quoteId]);

        return $items;
    }
}
