<?php
/**
 * states table's controller.
 *
 * Used to perform operations on states table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;



use App\Models\SmaStatesModel;
use CodeIgniter\RESTful\ResourceController;

class SmaStates extends ResourceController
{
    
    /**
     * @deprecated Not in use
     *
     * @return HttpResponse
     */
    public function sync(){

        $this->setModel(new SmaStatesModel($this->dbGroupFromRequest()));

        $rules = [
            'last_sync' => 'valid_date',
            // 'first_time'=> ''
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],
            // 'first_time' => [
            //     'required' => '',
            // ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $products_list = [];

            if($this->request->getVar('first_time')==true){

   
                $products_list = $this->getAllRows([]);



            }else if($this->request->getVar('first_time')==false){
                $products_list = $this->getUpdatedRows([]);
            }else{
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'EL campo "first_time" no es valido',
                    'data' => []
                ];
    
                return $this->respondCreated($response);
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time'=> $this->getServerDateTime(),
                'data' => $products_list
            ];

            return $this->respondCreated($response);

        }

    }

}