<?php
/**
 * warehouses_products table's controller.
 *
 * Used to perform operations on warehouses_products table.
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Controllers;



use App\Models\SmaWarehousesProductsModel;
use CodeIgniter\RESTful\ResourceController;

class SmaWarehousesProducts extends ResourceController
{
    
    /**
     * Get updated warehouses_products table's rows.
     *
     * 
     * Based on last_sync value (from request), return updated rows from warehouses_products.
     *
     * Request should contain last_sync value (date) to get updated rows based on
     * that date.
     *
     * If request contains first_time = true, it returns all data in  table.
     *
     *
     * @return HttpResponse 
    */
    public function sync(){

        $this->setModel(new SmaWarehousesProductsModel($this->dbGroupFromRequest()));

        $rules = [
            'last_sync' => 'valid_date',
            // 'first_time'=> ''
        ];
        $this->request;
        $message = [
            'last_sync' => [
                'required' => 'Tipo de dato no valido',
            ],
            // 'first_time' => [
            //     'required' => '',
            // ],
            
        ];

        // echo $this->request->();

        if (!$this->validate($rules, $message)) {

            // if validation fails

            $response = [
                'status' => 400,
                'error' => true,
                'message' => $this->validator->getErrors(),
                'data' => [],
                'date'=>$this->request->getVar('last_sync')
            ];

            return $this->respondCreated($response);
            
        } else {
            // validate
            $products_list = [];

            if($this->request->getVar('first_time')==true){

   
                $products_list = $this->getAllRows(['id'=>'id_cloud']);



            }else if($this->request->getVar('first_time')==false){
                $products_list = $this->getUpdatedRows(['id'=>'id_cloud']);
            }else{
                $response = [
                    'status' => 400,
                    'error' => true,
                    'message' => 'EL campo "first_time" no es valido',
                    'data' => []
                ];
    
                return $this->respondCreated($response);
            }

            $response = [
                'status' => 200,
                'error' => false,
                'message' => 'Exito',
                'server_date_time'=> $this->getServerDateTime(),
                'data' => $products_list
            ];

            return $this->respondCreated($response);

        }

    }

    /**
     * Returns list of arrays for rows in sma_warehouses_products where quantity of product 
     * in sale is more than the quantity of product in current warehouse;
     *
     * @param array $productsId
     * @param array $productsQuantity
     * @param int $warehouseId
     * @return array|null
     */
    static public function verifyProductsQuantities($productId, $pQuantity, $warehouseId,$dbGroup)
    {
        $wpModel = new SmaWarehousesProductsModel($dbGroup);
        $productQuantity = $wpModel->select($wpModel->getColumnsString())
            ->where(['warehouse_id' => $warehouseId, 'product_id' => $productId])
            ->first();
        if (!empty($productQuantity)) {
            if ($pQuantity > $productQuantity['quantity']) {
                return true;
            } else {
                return false;
            }
        }
    }

}