<?php

namespace App\Controllers;


//______________________________________________________________________________________________________________
//
//                                             Importations
//_______________________________________________________________________________________________________________

use CodeIgniter\HTTP\Response;
use CodeIgniter\RESTful\ResourceController;


class Utils extends ResourceController
{   
    /**
     * Function to make png jpgs with only black and white colors
     *
     * @return httpResponse
     */
    public function pngToJpg(){
        
        /* GET PARAMETERS */
        if ( $this->request->getVar('img')!==null){
            $imgUrl= $this->request->getVar('img'); 
        } else {
            $imgUrl= 'https://wappsi281.com/forbabys_prueba/assets/uploads/logos/logo_wappsi.png';
        }
        $png = imagecreatefrompng($imgUrl);

        $width = imagesx( $png );
        $height = imagesy( $png ); 

        $file = imagecreatetruecolor($width, $height);
        $kek=imagecolorallocate($file, 255, 255, 255);
        imagefill($file,0,0,$kek);
        imagecopyresampled($file, $png, 0, 0, 0, 0, $width, $height, $width, $height);
        $imgw = imagesx($file);
        $imgh = imagesy($file);

        for ($i=0; $i<$imgw; $i++)
        {
            for ($j=0; $j<$imgh; $j++)
            {

                    // Get the RGB value for current pixel

                    $rgb = ImageColorAt($file, $i, $j); 

                    // Extract each value for: R, G, B

                    $rr = ($rgb >> 16) & 0xFF;
                    $gg = ($rgb >> 8) & 0xFF;
                    $bb = $rgb & 0xFF;

                    // Get the value from the RGB value

                    $g = round(($rr + $gg + $bb) / 3);

                    // Gray-scale values have: R=G=B=G

                    $val = imagecolorallocate($file, $g, $g, $g);

                    // Set the gray value

                    imagesetpixel ($file, $i, $j, $val);
            }
        }

        // imagefilter($file, IMG_FILTER_GRAYSCALE);
    imagefilter($file, IMG_FILTER_CONTRAST, -1000);
        // imagejpeg($file, $photo_dest, 100);

        // Hacer las operaciones requeridas
        // echo "<img src= 'https://wappsi281.com/forbabys_prueba/assets/uploads/logos/logo_wappsi.png'>";
        // Desactivar la mezcla alfa y establecer la bandera alfa

        // Impirmir la imagen al navegador
        $this->response->setHeader('Content-type','image/jpg');

        imagejpeg($file);
        ImageDestroy($png);
        ImageDestroy($file);
    }


    /**
     * For a given jpg (with white background) image url, try to make a png and
     * return it.
     *
     * 
    */
    public function jpgWhiteToPng(){
        
        /* GET PARAMETERS */
        if ( $this->request->getVar('img')!==null){
            $imgUrl= $this->request->getVar('img'); 
        } else {
            $imgUrl= 'https://wappsi281.com/forbabys_prueba/assets/uploads/logos/logo_wappsi.png';
        }
        $image = imagecreatefromjpeg($imgUrl);
        imagealphablending($image, true);
        $transparentcolour = imagecolorallocate($image, 255,255,255);
        imagecolortransparent($image, $transparentcolour);

        $this->response->setHeader('Content-type','image/png');

        imagepng($image,null,1);
        ImageDestroy($image);
    }

    /**
     * For a given jpg (with black background) image url, try to make a png and
     * return it.
     *
     * 
    */
    public function jpgBlackToPng(){
        
        /* GET PARAMETERS */
        if ( $this->request->getVar('img')!==null){
            $imgUrl= $this->request->getVar('img'); 
        } else {
            $imgUrl= 'https://wappsi281.com/forbabys_prueba/assets/uploads/logos/logo_wappsi.png';
        }
        $image = imagecreatefromjpeg($imgUrl);
        imagealphablending($image, true);
        $transparentcolour = imagecolorallocate($image, 0,0,0);
        imagecolortransparent($image, $transparentcolour);

        $this->response->setHeader('Content-type','image/png');

        imagepng($image,null,1);
        ImageDestroy($image);
    }
}
