<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaBillerDataModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_biller_data';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    protected $allowedFieldsToApp       = [
        "id",
        "biller_id",
        "pos_document_type_default",
        "detal_document_type_default",
        "default_price_group",
        "default_warehouse_id",
        "default_customer_id",
        "default_seller_id",
        "key_log",
        "product_order",
        "purchases_document_type_default",
        "pin_code",
        "branch_type",
        "coverage_country",
        "coverage_state",
        "coverage_city",
        "coverage_zone",
        "prioridad_precios_producto",
        "language",
        "currency",
        "charge_shipping_cost",
        "shipping_cost",
        "max_total_shipping_cost",
        "concession_status",
        "default_pos_section",
        "preparation_adjustment_document_type_id",
        "default_cost_center_id",
        "rete_bomberil_percentage",
        "rete_bomberil_account",
        "rete_bomberil_account_counterpart",
        "rete_autoaviso_percentage",
        "rete_autoaviso_account",
        "rete_autoaviso_account_counterpart",
        "rete_autoica_percentage",
        "rete_autoica_account",
        "rete_autoica_account_counterpart",
        "cash_payment_method_account",
        "pin_code_request",
        "pin_code_method",
        "random_pin_code",
        "random_pin_code_date",
        "last_update",
        "order_sales_document_type_default",
        "min_sale_amount",
    ];
}
