<?php

namespace App\Models;

use CodeIgniter\Model;

class SmaQuoteItemsModel extends Model
{
    public function __construct(String $DBGroup = 'default')
    {   
        $this->DBGroup = $DBGroup;
        parent::__construct();
    }
    protected $DBGroup              = 'default';
    protected $table                = 'sma_quote_items';
    protected $primaryKey           = 'id';
    protected $useAutoIncrement     = true;
    protected $insertID             = 0;
    protected $returnType           = 'array';
    protected $useSoftDeletes       = false;
    protected $protectFields        = true;
    protected $allowedFields        = [
        "quote_id",
        "product_id",
        "product_code",
        "product_name",
        "product_type",
        "option_id",
        "net_unit_price",
        "unit_price",
        "quantity",
        "warehouse_id",
        "item_tax",
        "tax_rate_id",
        "tax",
        "item_tax_2",
        "tax_rate_2_id",
        "tax_2",
        "discount",
        "item_discount",
        "subtotal",
        "serial_no",
        "real_unit_price",
        "product_unit_id",
        "product_unit_code",
        "unit_quantity",
        "gst",
        "cgst",
        "sgst",
        "igst",
        "price_before_tax",
    ];

    // Dates
    protected $useTimestamps        = false;
    protected $dateFormat           = 'datetime';
    protected $createdField         = 'created_at';
    protected $updatedField         = 'updated_at';
    protected $deletedField         = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks       = true;
    protected $beforeInsert         = [];
    protected $afterInsert          = [];
    protected $beforeUpdate         = [];
    protected $afterUpdate          = [];
    protected $beforeFind           = [];
    protected $afterFind            = [];
    protected $beforeDelete         = [];
    protected $afterDelete          = [];

    // to app

    protected $allowedFieldsToApp       =[
        "id",
        "quote_id",
        "product_id",
        "product_code",
        "product_name",
        "product_type",
        "option_id",
        "net_unit_price",
        "unit_price",
        "quantity",
        "warehouse_id",
        "item_tax",
        "tax_rate_id",
        "tax",
        "item_tax_2",
        "tax_rate_2_id",
        "tax_2",
        "discount",
        "item_discount",
        "subtotal",
        "serial_no",
        "real_unit_price",
        "product_unit_id",
        "product_unit_code",
        "unit_quantity",
        "gst",
        "cgst",
        "sgst",
        "igst",
        "price_before_tax",
    ];
}
