<?php
/**
 * Use to manage validations of SmaAddressesController.
 *
 *
 * @author Mario Vallejo <wappsi.desarrollomovil01@gmail.com>
*/
namespace App\Validation;

// use App\Validation\GeneralRulesMessasges;
/**
 * This class contains statics methods to access multiple rules and valitations
 * used un SmaAddresses controller
 */
class SmaAddressesValidation extends GeneralValidations
{   

    /**
     * Addresses creation rules.
     * 
     * Here u can setup extra validation rules if required.
     *
     * @return  array
    */
    public static function addAddressRules()
    {
        return [
            'company_id' => 'numeric|required',
            'direccion' => 'string|required',
            'sucursal' => 'string|required',
            'city' => 'string|required',
            'state' => 'string|required',
            'country' => 'string|required',
            'phone' => 'string',
            'city_code' => 'string',
            'customer_address_seller_id_assigned' => 'numeric|required',
            'customer_group_id' => 'numeric',
            // 'second_name'=>'',
            'customer_group_name' => 'string',
            'price_group_name' => 'string',
            'price_group_id' => 'numeric',
            'code' => 'string',

            'email' => 'string',
            'vat_no' => 'numeric',
            // 'geo_location' => 'string',

        ];
    }

     /**
     * Addresses creation validation messages.
     * 
     * Here u can setup extra validation messages if required.
     *
     * @return  array
    */
    public static function addAddressMessages()
    {
        return [
            'company_id' => ['required' => 'El campo company_id es necesario'],
            'direccion' => ['required' => 'El campo direccion es necesario'],
            'sucursal' => ['required' => 'El campo sucursal es necesario'],
            // 'postal_code'=>'',
            'city' => ['required' => 'El campo city es necesario'],
            'state' => ['required' => 'El campo state es necesario'],
            'country' => ['required' => 'El campo country es necesario'],
            // 'phone'=>'',
            // 'city_code'=>'',
            // 'customer_address_seller_id_assigned'=>'',
            // 'customer_group_id'=>'',
            // 'customer_group_name'=>'',
            // 'price_group_name'=>'',
            // 'price_group_id'=>'',
            // 'code'=>'',
            // 'line1'=>'',
            // 'line2'=>'',
            // 'email'=>'',
            // 'vat_no'=>'',
            // 'geo_location'=>'',
        ];
    }

    /**
     * Addresses zone-subzone edit rules.
     * 
     * Here u can setup extra validation rules if required.
     *
     * @return  array
    */
    public static function addAddressZSzRules()
    {
        return [
            'address_id' => 'numeric|required',
            'zone_id' => 'numeric|required',
            // 'subzone_code' => 'numeric|required'
        ];
    }

     /**
     * Addresses zone-subzone edit messages.
     * 
     * Here u can setup extra validation messages if required.
     *
     * @return  array
    */
    public static function addAddressZsZMessages()
    {
        return [
            'address_id' => 'Id de sucursal requerido',
            'zone_id' => 'Id de zona requerido',
            // 'subzone_code' => 'Codigo de subzona requerido'
        ];
    }
}
